/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.trait;

import com.helger.base.string.StringHelper;
import com.helger.base.trait.IAddableByTrait;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.base.trait.IHasTypeConverterTo;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IGenericMapAdderTrait<KEYTYPE, VALUETYPE extends IAddableByTrait, IMPLTYPE extends IGenericMapAdderTrait<KEYTYPE, VALUETYPE, IMPLTYPE>>
extends IHasTypeConverterTo<VALUETYPE>,
IGenericImplTrait<IMPLTYPE> {
    public @NonNull IMPLTYPE add(@NonNull KEYTYPE var1, @NonNull VALUETYPE var2);

    default public @NonNull IMPLTYPE addIf(@NonNull KEYTYPE KEYTYPE, @NonNull VALUETYPE VALUETYPE, @NonNull Predicate<? super VALUETYPE> predicate) {
        if (predicate.test(VALUETYPE)) {
            this.add(KEYTYPE, VALUETYPE);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addIf(@NonNull KEYTYPE KEYTYPE, @NonNull VALUETYPE VALUETYPE, @NonNull BooleanSupplier booleanSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            this.add(KEYTYPE, VALUETYPE);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addIfNotNull(@NonNull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        if (VALUETYPE != null) {
            this.add(KEYTYPE, VALUETYPE);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE add(@NonNull KEYTYPE KEYTYPE, @Nullable Object object) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(object)));
    }

    default public @NonNull IMPLTYPE addIf(@NonNull KEYTYPE KEYTYPE, @Nullable Object object, @NonNull BooleanSupplier booleanSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            this.add(KEYTYPE, object);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public <T> @NonNull IMPLTYPE addIf(@NonNull KEYTYPE KEYTYPE, @Nullable T t, @NonNull Predicate<? super T> predicate) {
        if (predicate.test(t)) {
            this.add(KEYTYPE, t);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addIfNotNull(@NonNull KEYTYPE KEYTYPE, @Nullable Object object) {
        if (object != null) {
            this.add(KEYTYPE, object);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addIfNotEmpty(@NonNull KEYTYPE KEYTYPE, @Nullable String string) {
        if (StringHelper.isNotEmpty(string)) {
            this.add(KEYTYPE, string);
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE add(@NonNull Map.Entry<? extends KEYTYPE, ?> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    default public @NonNull IMPLTYPE add(@NonNull KEYTYPE KEYTYPE, boolean bl) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(bl)));
    }

    default public @NonNull IMPLTYPE add(@NonNull KEYTYPE KEYTYPE, char c) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(c)));
    }

    default public @NonNull IMPLTYPE add(@NonNull KEYTYPE KEYTYPE, double d) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(d)));
    }

    default public @NonNull IMPLTYPE add(@NonNull KEYTYPE KEYTYPE, int n) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(n)));
    }

    default public @NonNull IMPLTYPE add(@NonNull KEYTYPE KEYTYPE, long l) {
        return this.add(KEYTYPE, (VALUETYPE)((IAddableByTrait)this.getTypeConverterTo().convert(l)));
    }

    default public @NonNull IMPLTYPE addAll(@Nullable Iterable<Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (iterable != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : iterable) {
                this.add(entry.getKey(), (VALUETYPE)((IAddableByTrait)entry.getValue()));
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addAllAny(@Nullable Map<? extends KEYTYPE, ?> map) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, ?> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public @NonNull IMPLTYPE addAllAny(@Nullable Iterable<Map.Entry<KEYTYPE, ?>> iterable) {
        if (iterable != null) {
            for (Map.Entry<KEYTYPE, ?> entry : iterable) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public <SRCVALUETYPE> @NonNull IMPLTYPE addAllMapped(@Nullable Map<? extends KEYTYPE, ? extends SRCVALUETYPE> map, @NonNull Function<? super SRCVALUETYPE, VALUETYPE> function) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, SRCVALUETYPE> entry : map.entrySet()) {
                this.add(entry.getKey(), (VALUETYPE)((IAddableByTrait)function.apply(entry.getValue())));
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }

    default public <SRCKEYTYPE, SRCVALUETYPE> @NonNull IMPLTYPE addAllMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @NonNull Function<? super SRCKEYTYPE, KEYTYPE> function, @NonNull Function<? super SRCVALUETYPE, VALUETYPE> function2) {
        if (map != null) {
            for (Map.Entry<SRCKEYTYPE, SRCVALUETYPE> entry : map.entrySet()) {
                this.add(function.apply(entry.getKey()), (VALUETYPE)((IAddableByTrait)function2.apply(entry.getValue())));
            }
        }
        return (IMPLTYPE)((IGenericMapAdderTrait)this.thisAsT());
    }
}

