/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.scanner;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.ShutdownHook;
import com.googlecode.t7mp.scanner.Scanner;
import com.googlecode.t7mp.scanner.ScannerConfiguration;
import java.io.File;

public final class ScannerSetup {
    private ScannerSetup() {
    }

    public static void configureScanners(ShutdownHook shutdownHook, AbstractT7Mojo t7Mojo) {
        if (!t7Mojo.isWebProject()) {
            t7Mojo.getLog().info((CharSequence)"Project seems not to be an web-project (packaging 'war'), skip scanner configuration");
            return;
        }
        for (ScannerConfiguration scannerConfiguration : t7Mojo.getScanners()) {
            scannerConfiguration.setRootDirectory(t7Mojo.getWebappSourceDirectory());
            scannerConfiguration.setWebappDirectory(new File(t7Mojo.getCatalinaBase(), "webapps/" + t7Mojo.getContextPath()));
            Scanner scanner = new Scanner(scannerConfiguration, t7Mojo.getLog());
            scanner.start();
            shutdownHook.addScanner(scanner);
        }
        if (t7Mojo.isScanClasses()) {
            ScannerConfiguration scannerConfiguration = new ScannerConfiguration();
            scannerConfiguration.setRootDirectory(t7Mojo.getWebappClassDirectory());
            scannerConfiguration.setWebappDirectory(new File(t7Mojo.getCatalinaBase(), "webapps/" + t7Mojo.getContextPath() + "/WEB-INF/classes"));
            scannerConfiguration.setEndings("%");
            Scanner scanner = new Scanner(scannerConfiguration, t7Mojo.getLog());
            scanner.start();
            shutdownHook.addScanner(scanner);
        }
    }
}

