/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.math.DoubleMath;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.HashSet;

public final class TypeTransformationParser {
    private String typeTransformationString;
    private Node typeTransformationAst;
    private StaticSourceFile sourceFile;
    private ErrorReporter errorReporter;
    private int templateLineno;
    private int templateCharno;
    private static final int VAR_ARGS = 0x7FFFFFFE;

    public TypeTransformationParser(String typeTransformationString, StaticSourceFile sourceFile, ErrorReporter errorReporter, int templateLineno, int templateCharno) {
        this.typeTransformationString = typeTransformationString;
        this.sourceFile = sourceFile;
        this.errorReporter = errorReporter;
        this.templateLineno = templateLineno;
        this.templateCharno = templateCharno;
    }

    public Node getTypeTransformationAst() {
        return this.typeTransformationAst;
    }

    private void addNewWarning(String messageId, String messageArg, Node nodeWarning) {
        this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage1(messageId, messageArg), this.sourceFile.getName(), this.templateLineno, this.templateCharno);
    }

    private Keywords nameToKeyword(String s) {
        return Keywords.valueOf(s.toUpperCase());
    }

    private boolean isValidKeyword(String name) {
        for (Keywords k : Keywords.values()) {
            if (!k.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperationKind(String name, OperationKind kind) {
        return this.isValidKeyword(name) ? this.nameToKeyword((String)name).kind == kind : false;
    }

    private boolean isValidBooleanPredicate(String name) {
        return this.isOperationKind(name, OperationKind.BOOLEAN_PREDICATE);
    }

    private Node getCallArgument(Node n, int i) {
        return n.isCall() ? n.getChildAtIndex(i + 1) : null;
    }

    private boolean isTypeVar(Node n) {
        return n.isName();
    }

    private boolean isTypeName(Node n) {
        return n.isString();
    }

    private boolean isOperation(Node n) {
        return n.isCall();
    }

    private boolean isValidExpression(Node e) {
        return this.isTypeVar(e) || this.isTypeName(e) || this.isOperation(e);
    }

    private void warnInvalid(String msg, Node e) {
        this.addNewWarning("msg.jsdoc.typetransformation.invalid", msg, e);
    }

    private void warnInvalidExpression(String msg, Node e) {
        this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", msg, e);
    }

    private void warnMissingParam(String msg, Node e) {
        this.addNewWarning("msg.jsdoc.typetransformation.missing.param", msg, e);
    }

    private void warnExtraParam(String msg, Node e) {
        this.addNewWarning("msg.jsdoc.typetransformation.extra.param", msg, e);
    }

    private void warnInvalidInside(String msg, Node e) {
        this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", msg, e);
    }

    private boolean checkParameterCount(Node expr, Keywords keyword) {
        int numParams = expr.getChildCount();
        if (numParams < 1 + keyword.minParamCount) {
            this.warnMissingParam(keyword.name, expr);
            return false;
        }
        if (numParams > 1 + keyword.maxParamCount) {
            this.warnExtraParam(keyword.name, expr);
            return false;
        }
        return true;
    }

    public boolean parseTypeTransformation() {
        Config config = new Config(new HashSet<String>(), new HashSet<String>(), true, true, Config.LanguageMode.ECMASCRIPT6, false);
        ParserRunner.ParseResult result = ParserRunner.parse(this.sourceFile, this.typeTransformationString, config, this.errorReporter);
        Node ast = result.ast;
        if (!ast.isScript() || !ast.getFirstChild().isExprResult()) {
            this.warnInvalidExpression("type transformation", ast);
            return false;
        }
        Node expr = ast.getFirstChild().getFirstChild();
        if (!this.validTypeTransformationExpression(expr)) {
            return false;
        }
        this.typeTransformationAst = expr;
        return true;
    }

    private boolean validTemplateTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.TYPE)) {
            return false;
        }
        int numParams = expr.getChildCount() - 1;
        Node firstParam = this.getCallArgument(expr, 0);
        if (!this.isTypeVar(firstParam) && !this.isTypeName(firstParam)) {
            this.warnInvalid("type name or type variable", expr);
            this.warnInvalidInside("template type operation", expr);
            return false;
        }
        for (int i = 1; i < numParams; ++i) {
            if (this.validTypeTransformationExpression(this.getCallArgument(expr, i))) continue;
            this.warnInvalidInside("template type operation", expr);
            return false;
        }
        return true;
    }

    private boolean validUnionTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.UNION)) {
            return false;
        }
        int numParams = expr.getChildCount() - 1;
        for (int i = 0; i < numParams; ++i) {
            if (this.validTypeTransformationExpression(expr.getChildAtIndex(i))) continue;
            this.warnInvalidInside("union type", expr);
            return false;
        }
        return true;
    }

    private boolean validNoneTypeExpression(Node expr) {
        return this.checkParameterCount(expr, Keywords.NONE);
    }

    private boolean validRawTypeOfTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.RAWTYPEOF)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside("rawTypeOf", expr);
            return false;
        }
        return true;
    }

    private boolean validTemplateTypeOfExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.TEMPLATETYPEOF)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside("templateTypeOf", expr);
            return false;
        }
        if (!this.getCallArgument(expr, 1).isNumber()) {
            this.warnInvalid("index", expr);
            this.warnInvalidInside("templateTypeOf", expr);
            return false;
        }
        double index = this.getCallArgument(expr, 1).getDouble();
        if (!DoubleMath.isMathematicalInteger((double)index) || index < 0.0) {
            this.warnInvalid("index", expr);
            this.warnInvalidInside("templateTypeOf", expr);
            return false;
        }
        return true;
    }

    private boolean validRecordTypeExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.RECORD)) {
            return false;
        }
        Node record = this.getCallArgument(expr, 0);
        if (!record.isObjectLit()) {
            this.warnInvalid("record expression", record);
            return false;
        }
        if (record.getChildCount() < 1) {
            this.warnMissingParam("record expression", record);
            return false;
        }
        for (Node prop : record.children()) {
            if (!prop.hasChildren()) {
                this.warnInvalid("property, missing type", prop);
                this.warnInvalidInside("record", prop);
                return false;
            }
            if (this.validTypeTransformationExpression(prop.getFirstChild())) continue;
            this.warnInvalidInside("record", prop);
            return false;
        }
        return true;
    }

    private boolean validTypeExpression(Node expr) {
        String name = expr.getFirstChild().getString();
        Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case TYPE: {
                return this.validTemplateTypeExpression(expr);
            }
            case UNION: {
                return this.validUnionTypeExpression(expr);
            }
            case NONE: {
                return this.validNoneTypeExpression(expr);
            }
            case RAWTYPEOF: {
                return this.validRawTypeOfTypeExpression(expr);
            }
            case TEMPLATETYPEOF: {
                return this.validTemplateTypeOfExpression(expr);
            }
            case RECORD: {
                return this.validRecordTypeExpression(expr);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private boolean validBooleanTypeExpression(Node expr) {
        if (!this.isOperation(expr)) {
            this.warnInvalidExpression("boolean", expr);
            return false;
        }
        String predicate = expr.getFirstChild().getString();
        if (!this.isValidBooleanPredicate(predicate)) {
            this.warnInvalid("boolean predicate", expr);
            return false;
        }
        if (!this.checkParameterCount(expr, Keywords.EQ)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0)) || !this.validTypeTransformationExpression(this.getCallArgument(expr, 1))) {
            this.warnInvalidInside("boolean", expr);
            return false;
        }
        return true;
    }

    private boolean validConditionalExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.COND)) {
            return false;
        }
        if (!this.validBooleanTypeExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside("conditional", expr);
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 1))) {
            this.warnInvalidInside("conditional", expr);
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 2))) {
            this.warnInvalidInside("conditional", expr);
            return false;
        }
        return true;
    }

    private boolean validMapunionExpression(Node expr) {
        if (!this.checkParameterCount(expr, Keywords.MAPUNION)) {
            return false;
        }
        if (!this.validTypeTransformationExpression(this.getCallArgument(expr, 0))) {
            this.warnInvalidInside("mapunion", this.getCallArgument(expr, 0));
            return false;
        }
        if (!this.getCallArgument(expr, 1).isFunction()) {
            this.warnInvalid("map function", this.getCallArgument(expr, 1));
            return false;
        }
        Node mapFn = this.getCallArgument(expr, 1);
        Node mapFnParam = mapFn.getChildAtIndex(1);
        if (!mapFnParam.hasChildren()) {
            this.warnMissingParam("map function", mapFnParam);
            return false;
        }
        if (!mapFnParam.hasOneChild()) {
            this.warnExtraParam("map function", mapFnParam);
            return false;
        }
        Node mapFnBody = mapFn.getChildAtIndex(2);
        if (!this.validTypeTransformationExpression(mapFnBody)) {
            this.warnInvalidInside("map function body", mapFnBody);
            return false;
        }
        return true;
    }

    private boolean validOperationExpression(Node expr) {
        String name = expr.getFirstChild().getString();
        Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case COND: {
                return this.validConditionalExpression(expr);
            }
            case MAPUNION: {
                return this.validMapunionExpression(expr);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private boolean validTypeTransformationExpression(Node expr) {
        if (!this.isValidExpression(expr)) {
            this.warnInvalidExpression("type transformation", expr);
            return false;
        }
        if (this.isTypeVar(expr) || this.isTypeName(expr)) {
            return true;
        }
        String name = expr.getFirstChild().getString();
        if (!this.isValidKeyword(name)) {
            this.warnInvalidExpression("type transformation", expr);
            return false;
        }
        Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case TYPE_CONSTRUCTOR: {
                return this.validTypeExpression(expr);
            }
            case OPERATION: {
                return this.validOperationExpression(expr);
            }
        }
        throw new IllegalStateException("Invalid type transformation expression");
    }

    public static enum Keywords {
        TYPE("type", 2, 0x7FFFFFFE, OperationKind.TYPE_CONSTRUCTOR),
        UNION("union", 2, 0x7FFFFFFE, OperationKind.TYPE_CONSTRUCTOR),
        COND("cond", 3, 3, OperationKind.OPERATION),
        MAPUNION("mapunion", 2, 2, OperationKind.OPERATION),
        EQ("eq", 2, 2, OperationKind.BOOLEAN_PREDICATE),
        SUB("sub", 2, 2, OperationKind.BOOLEAN_PREDICATE),
        NONE("none", 0, 0, OperationKind.TYPE_CONSTRUCTOR),
        RAWTYPEOF("rawTypeOf", 1, 1, OperationKind.TYPE_CONSTRUCTOR),
        TEMPLATETYPEOF("templateTypeOf", 2, 2, OperationKind.TYPE_CONSTRUCTOR),
        RECORD("record", 1, 1, OperationKind.TYPE_CONSTRUCTOR);

        public final String name;
        public final int minParamCount;
        public final int maxParamCount;
        public final OperationKind kind;

        private Keywords(String name, int minParamCount, int maxParamCount, OperationKind kind) {
            this.name = name;
            this.minParamCount = minParamCount;
            this.maxParamCount = maxParamCount;
            this.kind = kind;
        }
    }

    public static enum OperationKind {
        TYPE_CONSTRUCTOR,
        OPERATION,
        BOOLEAN_PREDICATE;

    }
}

