/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.JSType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class Property {
    private final JSType inferredType;
    private final JSType declaredType;
    private Attribute attribute;

    private Property(JSType inferredType, JSType declaredType, Attribute attribute) {
        Preconditions.checkArgument((inferredType != null ? 1 : 0) != 0);
        this.inferredType = inferredType;
        this.declaredType = declaredType;
        this.attribute = attribute;
    }

    static Property make(JSType inferredType, JSType declaredType) {
        return new Property(inferredType, declaredType, Attribute.REQUIRED);
    }

    static Property makeConstant(JSType inferredType, JSType declaredType) {
        return new Property(inferredType, declaredType, Attribute.CONSTANT);
    }

    static Property makeOptional(JSType inferredType, JSType declaredType) {
        return new Property(inferredType, declaredType, Attribute.OPTIONAL);
    }

    boolean isOptional() {
        return this.attribute == Attribute.OPTIONAL;
    }

    boolean isConstant() {
        return this.attribute == Attribute.CONSTANT;
    }

    boolean isDeclared() {
        return this.declaredType != null;
    }

    boolean hasFreeTypeVars(Set<String> boundTypeVars) {
        return this.declaredType != null && this.declaredType.hasFreeTypeVars(boundTypeVars) || this.inferredType != null && this.inferredType.hasFreeTypeVars(boundTypeVars);
    }

    JSType getType() {
        return this.inferredType;
    }

    JSType getDeclaredType() {
        return this.declaredType;
    }

    Property withOptional() {
        return new Property(this.inferredType, this.declaredType, Attribute.OPTIONAL);
    }

    Property withRequired() {
        return new Property(this.inferredType, this.declaredType, Attribute.REQUIRED);
    }

    private static Attribute meetAttributes(Attribute a1, Attribute a2) {
        if (a1 == Attribute.CONSTANT || a2 == Attribute.CONSTANT) {
            return Attribute.CONSTANT;
        }
        if (a1 == Attribute.REQUIRED || a2 == Attribute.REQUIRED) {
            return Attribute.REQUIRED;
        }
        return Attribute.OPTIONAL;
    }

    private static Attribute joinAttributes(Attribute a1, Attribute a2) {
        if (a1 == Attribute.OPTIONAL || a2 == Attribute.OPTIONAL) {
            return Attribute.OPTIONAL;
        }
        if (a1 == Attribute.REQUIRED || a2 == Attribute.REQUIRED) {
            return Attribute.REQUIRED;
        }
        return Attribute.CONSTANT;
    }

    Property specialize(Property other) {
        return new Property(this.inferredType.specialize(other.inferredType), this.declaredType, Property.meetAttributes(this.attribute, other.attribute));
    }

    static Property meet(Property p1, Property p2) {
        return new Property(JSType.meet(p1.inferredType, p2.inferredType), null, Property.meetAttributes(p1.attribute, p2.attribute));
    }

    static Property join(Property p1, Property p2) {
        JSType p1decl = p1.declaredType;
        JSType p2decl = p2.declaredType;
        JSType declType = p1decl == null || p2decl == null ? null : (p1decl.equals(p2decl) ? p1decl : null);
        return new Property(JSType.join(p1.inferredType, p2.inferredType), declType, Property.joinAttributes(p1.attribute, p2.attribute));
    }

    static Property unifyUnknowns(Property p1, Property p2) {
        JSType unifiedDeclaredType = null;
        if (p1.declaredType != null && p2.declaredType != null && (unifiedDeclaredType = JSType.unifyUnknowns(p1.declaredType, p2.declaredType)) == null) {
            return null;
        }
        JSType unifiedInferredType = JSType.unifyUnknowns(p1.inferredType, p2.inferredType);
        if (unifiedInferredType == null) {
            return null;
        }
        return new Property(unifiedInferredType, unifiedDeclaredType, Property.meetAttributes(p1.attribute, p2.attribute));
    }

    boolean unifyWith(Property other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        if (!this.inferredType.unifyWith(other.inferredType, typeParameters, typeMultimap)) {
            return false;
        }
        return this.declaredType == null || other.declaredType == null || this.declaredType.unifyWith(other.declaredType, typeParameters, typeMultimap);
    }

    Property substituteGenerics(Map<String, JSType> concreteTypes) {
        if (concreteTypes.isEmpty() || !this.hasFreeTypeVars(new HashSet<String>())) {
            return this;
        }
        return new Property(this.inferredType.substituteGenerics(concreteTypes), this.declaredType == null ? null : this.declaredType.substituteGenerics(concreteTypes), this.attribute);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        switch (this.attribute) {
            case CONSTANT: {
                return this.inferredType.appendTo(builder).append('^');
            }
            case REQUIRED: {
                return this.inferredType.appendTo(builder);
            }
            case OPTIONAL: {
                return this.inferredType.appendTo(builder).append('=');
            }
        }
        throw new RuntimeException("Unknown Attribute value " + (Object)((Object)this.attribute));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof Property));
        Property p2 = (Property)o;
        return this.inferredType.equals(p2.inferredType) && this.attribute == p2.attribute;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inferredType, this.attribute});
    }

    private static enum Attribute {
        CONSTANT,
        OPTIONAL,
        REQUIRED;

    }
}

