/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeInference;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class TypeInferencePass
implements CompilerPass {
    static final DiagnosticType DATAFLOW_ERROR = DiagnosticType.warning("JSC_INTERNAL_ERROR_DATAFLOW", "non-monotonic data-flow analysis");
    private final AbstractCompiler compiler;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private Scope topScope;
    private ScopeCreator scopeCreator;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;
    private final Multimap<Scope, Scope.Var> escapedLocalVars = HashMultimap.create();

    TypeInferencePass(AbstractCompiler abstractCompiler, ReverseAbstractInterpreter reverseAbstractInterpreter, Scope scope, ScopeCreator scopeCreator) {
        this.compiler = abstractCompiler;
        this.reverseInterpreter = reverseAbstractInterpreter;
        this.topScope = scope;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionsMap = Maps.newHashMap();
        for (CodingConvention.AssertionFunctionSpec assertionFunctionSpec : abstractCompiler.getCodingConvention().getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFunctionSpec.getFunctionName(), assertionFunctionSpec);
        }
    }

    @Override
    public void process(Node node, Node node2) {
        Node node3 = node2.getParent();
        Preconditions.checkState((node3 != null ? 1 : 0) != 0);
        Preconditions.checkState((node == null || node3.hasChild(node) ? 1 : 0) != 0);
        this.inferTypes(node3);
    }

    void inferTypes(Node node) {
        NodeTraversal nodeTraversal = new NodeTraversal(this.compiler, new TypeInferringCallback(), this.scopeCreator);
        nodeTraversal.traverseWithScope(node, this.topScope);
    }

    private Collection<Scope.Var> getUnflowableVars(Scope scope) {
        ArrayList arrayList = Lists.newArrayList();
        Scope scope2 = scope;
        while (scope2.isLocal()) {
            arrayList.addAll(this.escapedLocalVars.get((Object)scope2));
            scope2 = scope2.getParent();
        }
        return arrayList;
    }

    void inferTypes(NodeTraversal nodeTraversal, Node node, Scope scope) {
        TypeInference typeInference = new TypeInference(this.compiler, this.computeCfg(node), this.reverseInterpreter, scope, this.assertionFunctionsMap, this.getUnflowableVars(scope));
        try {
            typeInference.analyze();
            this.escapedLocalVars.putAll(typeInference.getAssignedOuterLocalVars());
            this.compiler.getTypeRegistry().resolveTypesInScope(scope);
        }
        catch (DataFlowAnalysis.MaxIterationsExceededException maxIterationsExceededException) {
            this.compiler.report(nodeTraversal.makeError(node, DATAFLOW_ERROR, new String[0]));
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node node) {
        ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this.compiler, false, false);
        controlFlowAnalysis.process(null, node);
        return controlFlowAnalysis.getCfg();
    }

    private class TypeInferringCallback
    implements NodeTraversal.ScopedCallback {
        private TypeInferringCallback() {
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            Scope scope = nodeTraversal.getScope();
            Node node = nodeTraversal.getCurrentNode();
            if (scope.isGlobal()) {
                TypeInferencePass.this.inferTypes(nodeTraversal, node, scope);
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            Scope scope = nodeTraversal.getScope();
            Node node = nodeTraversal.getCurrentNode();
            if (scope.isLocal()) {
                TypeInferencePass.this.inferTypes(nodeTraversal, node, scope);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }
    }
}

