/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class UnionType
extends JSType {
    private static final long serialVersionUID = 1L;
    Collection<JSType> alternates;
    private final int hashcode;

    UnionType(JSTypeRegistry registry, Collection<JSType> alternates) {
        super(registry);
        this.alternates = alternates;
        this.hashcode = this.alternates.hashCode();
    }

    public Iterable<JSType> getAlternates() {
        return this.alternates;
    }

    @Override
    public boolean matchesNumberContext() {
        for (JSType t : this.alternates) {
            if (!t.matchesNumberContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        for (JSType t : this.alternates) {
            if (!t.matchesStringContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesObjectContext() {
        for (JSType t : this.alternates) {
            if (!t.matchesObjectContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        JSType propertyType = null;
        for (JSType alternate : this.getAlternates()) {
            JSType altPropertyType;
            if (alternate.isNullType() || alternate.isVoidType() || (altPropertyType = alternate.findPropertyType(propertyName)) == null) continue;
            if (propertyType == null) {
                propertyType = altPropertyType;
                continue;
            }
            propertyType = propertyType.getLeastSupertype(altPropertyType);
        }
        return propertyType;
    }

    @Override
    public boolean canBeCalled() {
        for (JSType t : this.alternates) {
            if (t.canBeCalled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType autobox() {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (JSType t : this.alternates) {
            restricted.addAlternate(t.autobox());
        }
        return restricted.build();
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (JSType t : this.alternates) {
            restricted.addAlternate(t.restrictByNotNullOrUndefined());
        }
        return restricted.build();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = null;
        for (JSType t : this.alternates) {
            TernaryValue test = t.testForEquality(that);
            if (result == null) {
                result = test;
                continue;
            }
            if (result.equals((Object)test)) continue;
            return TernaryValue.UNKNOWN;
        }
        return result;
    }

    @Override
    public boolean isNullable() {
        for (JSType t : this.alternates) {
            if (!t.isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnknownType() {
        for (JSType t : this.alternates) {
            if (!t.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStruct() {
        for (JSType typ : this.getAlternates()) {
            if (!typ.isStruct()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDict() {
        for (JSType typ : this.getAlternates()) {
            if (!typ.isDict()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        if (!that.isUnknownType() && !that.isUnionType()) {
            for (JSType alternate : this.alternates) {
                if (alternate.isUnknownType() || !that.isSubtype(alternate)) continue;
                return this;
            }
        }
        return UnionType.getLeastSupertype(this, that);
    }

    JSType meet(JSType that) {
        JSType result;
        UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
        for (JSType alternate : this.alternates) {
            if (!alternate.isSubtype(that)) continue;
            builder.addAlternate(alternate);
        }
        if (that.isUnionType()) {
            for (JSType otherAlternate : that.toMaybeUnionType().alternates) {
                if (!otherAlternate.isSubtype(this)) continue;
                builder.addAlternate(otherAlternate);
            }
        } else if (that.isSubtype(this)) {
            builder.addAlternate(that);
        }
        if (!(result = builder.build()).isNoType()) {
            return result;
        }
        if (this.isObject() && that.isObject() && !that.isNoType()) {
            return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    boolean checkUnionEquivalenceHelper(UnionType that, EquivalenceMethod eqMethod) {
        if (eqMethod == EquivalenceMethod.IDENTITY && this.alternates.size() != that.alternates.size()) {
            return false;
        }
        for (JSType alternate : that.alternates) {
            if (this.hasAlternate(alternate, eqMethod)) continue;
            return false;
        }
        return true;
    }

    private boolean hasAlternate(JSType type, EquivalenceMethod eqMethod) {
        for (JSType alternate : this.alternates) {
            if (!alternate.checkEquivalenceHelper(type, eqMethod)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasProperty(String pname) {
        for (JSType alternate : this.alternates) {
            if (!alternate.hasProperty(pname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this;
    }

    @Override
    public boolean isObject() {
        for (JSType alternate : this.alternates) {
            if (alternate.isObject()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(JSType type) {
        for (JSType alt : this.alternates) {
            if (!alt.isEquivalentTo(type)) continue;
            return true;
        }
        return false;
    }

    public JSType getRestrictedUnion(JSType type) {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (JSType t : this.alternates) {
            if (!t.isUnknownType() && !t.isNoResolvedType() && t.isSubtype(type)) continue;
            restricted.addAlternate(t);
        }
        return restricted.build();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        StringBuilder result = new StringBuilder();
        boolean firstAlternate = true;
        result.append("(");
        TreeSet<JSType> sorted = new TreeSet<JSType>(ALPHA);
        sorted.addAll(this.alternates);
        for (JSType t : sorted) {
            if (!firstAlternate) {
                result.append("|");
            }
            result.append(t.toStringHelper(forAnnotations));
            firstAlternate = false;
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public boolean isSubtype(JSType that) {
        if (that.isUnknownType()) {
            return true;
        }
        if (that.isAllType()) {
            return true;
        }
        for (JSType element : this.alternates) {
            if (element.isSubtype(that)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean outcome) {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (JSType element : this.alternates) {
            restricted.addAlternate(element.getRestrictedTypeGivenToBooleanOutcome(outcome));
        }
        return restricted.build();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        JSType element;
        BooleanLiteralSet literals = BooleanLiteralSet.EMPTY;
        Iterator<JSType> i$ = this.alternates.iterator();
        while (i$.hasNext() && (literals = literals.union((element = i$.next()).getPossibleToBooleanOutcomes())) != BooleanLiteralSet.BOTH) {
        }
        return literals;
    }

    @Override
    public JSType.TypePair getTypesUnderEquality(JSType that) {
        UnionTypeBuilder thisRestricted = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder thatRestricted = new UnionTypeBuilder(this.registry);
        for (JSType element : this.alternates) {
            JSType.TypePair p = element.getTypesUnderEquality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderInequality(JSType that) {
        UnionTypeBuilder thisRestricted = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder thatRestricted = new UnionTypeBuilder(this.registry);
        for (JSType element : this.alternates) {
            JSType.TypePair p = element.getTypesUnderInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderShallowInequality(JSType that) {
        UnionTypeBuilder thisRestricted = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder thatRestricted = new UnionTypeBuilder(this.registry);
        for (JSType element : this.alternates) {
            JSType.TypePair p = element.getTypesUnderShallowInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseUnionType(this, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.setResolvedTypeInternal(this);
        boolean changed = false;
        ImmutableList.Builder resolvedTypes = ImmutableList.builder();
        for (JSType alternate : this.alternates) {
            JSType newAlternate;
            changed |= alternate != (newAlternate = alternate.resolve(t, scope));
            resolvedTypes.add((Object)alternate);
        }
        if (changed) {
            ImmutableList newAlternates = resolvedTypes.build();
            Preconditions.checkState((newAlternates.hashCode() == this.hashcode ? 1 : 0) != 0);
            this.alternates = newAlternates;
        }
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        ArrayList hashCodes = Lists.newArrayList();
        for (JSType a : this.alternates) {
            hashCodes.add(a.toDebugHashCodeString());
        }
        return "{(" + Joiner.on((String)",").join((Iterable)hashCodes) + ")}";
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        for (JSType a : this.alternates) {
            a.setValidator(validator);
        }
        return true;
    }

    @Override
    public JSType collapseUnion() {
        JSType currentValue = null;
        ObjectType currentCommonSuper = null;
        for (JSType a : this.alternates) {
            if (a.isUnknownType()) {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            ObjectType obj = a.toObjectType();
            if (obj == null) {
                if (currentValue == null && currentCommonSuper == null) {
                    currentValue = a;
                    continue;
                }
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (currentValue != null) {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (currentCommonSuper == null) {
                currentCommonSuper = obj;
                continue;
            }
            currentCommonSuper = this.registry.findCommonSuperObject(currentCommonSuper, obj);
        }
        return currentCommonSuper;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        for (JSType alternate : this.alternates) {
            alternate.matchConstraint(constraint);
        }
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        for (JSType alternate : this.alternates) {
            if (!alternate.hasAnyTemplateTypes()) continue;
            return true;
        }
        return false;
    }
}

