/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeInference;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import java.util.Map;

class TypeInferencePass
implements CompilerPass {
    static final DiagnosticType DATAFLOW_ERROR = DiagnosticType.warning("JSC_INTERNAL_ERROR_DATAFLOW", "non-monotonic data-flow analysis");
    private final AbstractCompiler compiler;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private Scope topScope;
    private MemoizedScopeCreator scopeCreator;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;

    TypeInferencePass(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, Scope topScope, MemoizedScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.reverseInterpreter = reverseInterpreter;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionsMap = Maps.newHashMap();
        for (CodingConvention.AssertionFunctionSpec assertionFucntion : compiler.getCodingConvention().getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFucntion.getFunctionName(), assertionFucntion);
        }
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Node externsAndJs = jsRoot.getParent();
        Preconditions.checkState((externsAndJs != null ? 1 : 0) != 0);
        Preconditions.checkState((externsRoot == null || externsAndJs.hasChild(externsRoot) ? 1 : 0) != 0);
        this.inferAllScopes(externsAndJs);
    }

    void inferAllScopes(Node node) {
        new NodeTraversal(this.compiler, new FirstScopeBuildingCallback(), this.scopeCreator).traverseWithScope(node, this.topScope);
        new NodeTraversal(this.compiler, new SecondScopeBuildingCallback(), this.scopeCreator).traverseWithScope(node, this.topScope);
    }

    void inferScope(Node n, Scope scope) {
        TypeInference typeInference = new TypeInference(this.compiler, this.computeCfg(n), this.reverseInterpreter, scope, this.assertionFunctionsMap);
        try {
            typeInference.analyze();
            this.compiler.getTypeRegistry().resolveTypesInScope(scope);
        }
        catch (DataFlowAnalysis.MaxIterationsExceededException e) {
            this.compiler.report(JSError.make(n.getSourceFileName(), n, DATAFLOW_ERROR, new String[0]));
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node n) {
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, n);
        return cfa.getCfg();
    }

    private class SecondScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private SecondScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            TypeInferencePass.this.inferScope(t.getCurrentNode(), t.getScope());
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private class FirstScopeBuildingCallback
    extends NodeTraversal.AbstractScopedCallback {
        private FirstScopeBuildingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getScope();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

