/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.regex.RegExpTree;
import com.google.javascript.rhino.Node;

class CheckRegExp
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType REGEXP_REFERENCE = DiagnosticType.warning("JSC_REGEXP_REFERENCE", "References to the global RegExp object prevents optimization of regular expressions.");
    static final DiagnosticType MALFORMED_REGEXP = DiagnosticType.warning("JSC_MALFORMED_REGEXP", "Malformed Regular Expression: {0}");
    private final AbstractCompiler compiler;
    private boolean globalRegExpPropertiesUsed = false;

    public boolean isGlobalRegExpPropertiesUsed() {
        return this.globalRegExpPropertiesUsed;
    }

    public CheckRegExp(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isReferenceName(n)) {
            String name = n.getString();
            if (name.equals("RegExp") && t.getScope().getVar(name) == null) {
                boolean first;
                int parentType = parent.getType();
                boolean bl = first = n == parent.getFirstChild();
                if (!(parentType == 30 && first || parentType == 37 && first || parentType == 52 && !first)) {
                    t.report(n, REGEXP_REFERENCE, new String[0]);
                    this.globalRegExpPropertiesUsed = true;
                }
            }
        } else if (n.isRegExp()) {
            String pattern = n.getFirstChild().getString();
            String flags = n.getChildCount() == 2 ? n.getLastChild().getString() : "";
            try {
                RegExpTree.parseRegExp(pattern, flags);
            }
            catch (IllegalArgumentException ex) {
                t.report(n, MALFORMED_REGEXP, ex.getMessage());
            }
        }
    }
}

