/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Map;

class CheckProvides
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel checkLevel;
    private final CodingConvention codingConvention;
    static final DiagnosticType MISSING_PROVIDE_WARNING = DiagnosticType.disabled("JSC_MISSING_PROVIDE", "missing goog.provide(''{0}'')");

    CheckProvides(AbstractCompiler compiler, CheckLevel checkLevel) {
        this.compiler = compiler;
        this.checkLevel = checkLevel;
        this.codingConvention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CheckProvidesCallback callback = new CheckProvidesCallback(this.codingConvention);
        new NodeTraversal(this.compiler, callback).traverse(scriptRoot);
    }

    private class CheckProvidesCallback
    extends NodeTraversal.AbstractShallowCallback {
        private final Map<String, Node> provides = Maps.newHashMap();
        private final Map<String, Node> ctors = Maps.newHashMap();
        private final CodingConvention convention;

        CheckProvidesCallback(CodingConvention convention) {
            this.convention = convention;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 37: {
                    String providedClassName = CheckProvides.this.codingConvention.extractClassNameIfProvide(n, parent);
                    if (providedClassName == null) break;
                    this.provides.put(providedClassName, n);
                    break;
                }
                case 105: {
                    this.visitFunctionNode(n, parent);
                    break;
                }
                case 132: {
                    this.visitScriptNode(t, n);
                }
            }
        }

        private void visitFunctionNode(Node n, Node parent) {
            JSDocInfo.Visibility visibility;
            String qualifiedName;
            Node name = null;
            JSDocInfo info = parent.getJSDocInfo();
            if (info != null && info.isConstructor()) {
                name = parent.getFirstChild();
            } else {
                info = n.getJSDocInfo();
                if (info != null && info.isConstructor()) {
                    name = n.getFirstChild();
                }
            }
            if (name != null && name.isQualifiedName() && !this.convention.isPrivate(qualifiedName = name.getQualifiedName()) && !(visibility = info.getVisibility()).equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                this.ctors.put(qualifiedName, name);
            }
        }

        private void visitScriptNode(NodeTraversal t, Node n) {
            for (Map.Entry<String, Node> ctorEntry : this.ctors.entrySet()) {
                String ctor = ctorEntry.getKey();
                int index = -1;
                boolean found = false;
                do {
                    String provideKey;
                    String string = provideKey = (index = ctor.indexOf(46, index + 1)) == -1 ? ctor : ctor.substring(0, index);
                    if (!this.provides.containsKey(provideKey)) continue;
                    found = true;
                    break;
                } while (index != -1);
                if (found) continue;
                CheckProvides.this.compiler.report(t.makeError(ctorEntry.getValue(), CheckProvides.this.checkLevel, MISSING_PROVIDE_WARNING, ctorEntry.getKey()));
            }
            this.provides.clear();
            this.ctors.clear();
        }
    }
}

