/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.debugging.sourcemap.Util;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;

public class SourceMapGeneratorV1
implements SourceMapGenerator {
    private static final int UNMAPPED = -1;
    private List<Mapping> mappings = Lists.newArrayList();
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);

    private static String escapeString(String value) {
        return Util.escapeString(value);
    }

    @Override
    public void addMapping(String sourceName, @Nullable String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
        if (sourceName == null || sourceStartPosition.getLine() < 0) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = sourceName;
        mapping.originalPosition = sourceStartPosition;
        mapping.originalName = symbolName;
        if (this.offsetPosition.getLine() == 0 && this.offsetPosition.getColumn() == 0) {
            mapping.startPosition = startPosition;
            mapping.endPosition = endPosition;
        } else {
            int offsetLine = this.offsetPosition.getLine();
            int startOffsetPosition = this.offsetPosition.getColumn();
            int endOffsetPosition = this.offsetPosition.getColumn();
            if (startPosition.getLine() > 0) {
                startOffsetPosition = 0;
            }
            if (endPosition.getLine() > 0) {
                endOffsetPosition = 0;
            }
            mapping.startPosition = new FilePosition(startPosition.getLine() + offsetLine, startPosition.getColumn() + startOffsetPosition);
            mapping.endPosition = new FilePosition(endPosition.getLine() + offsetLine, endPosition.getColumn() + endOffsetPosition);
        }
        if (this.lastMapping != null) {
            int lastLine = this.lastMapping.startPosition.getLine();
            int lastColumn = this.lastMapping.startPosition.getColumn();
            int nextLine = mapping.startPosition.getLine();
            int nextColumn = mapping.startPosition.getColumn();
            Preconditions.checkState((nextLine > lastLine || nextLine == lastLine && nextColumn >= lastColumn ? 1 : 0) != 0, (String)"Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)\nnode : %s", (Object[])new Object[]{lastLine, lastColumn, nextLine, nextColumn});
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void setWrapperPrefix(String prefix) {
        int prefixLine = 0;
        int prefixIndex = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == '\n') {
                ++prefixLine;
                prefixIndex = 0;
                continue;
            }
            ++prefixIndex;
        }
        this.prefixPosition = new FilePosition(prefixLine, prefixIndex);
    }

    @Override
    public void setStartingPosition(int offsetLine, int offsetIndex) {
        Preconditions.checkState((offsetLine >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((offsetIndex >= 0 ? 1 : 0) != 0);
        this.offsetPosition = new FilePosition(offsetLine, offsetIndex);
    }

    @Override
    public void reset() {
        this.mappings = Lists.newArrayList();
        this.lastMapping = null;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    public void appendTo(Appendable out, String name) throws IOException {
        int maxLine = this.prepMappings();
        out.append("/** Begin line maps. **/{ \"file\" : ");
        out.append(SourceMapGeneratorV1.escapeString(name));
        out.append(", \"count\": ");
        out.append(String.valueOf(maxLine + 1));
        out.append(" }\n");
        new LineMapper(out).appendLineMappings();
        out.append("/** Begin file information. **/\n");
        for (int i = 0; i <= maxLine; ++i) {
            out.append("[]\n");
        }
        out.append("/** Begin mapping definitions. **/\n");
        new MappingWriter().appendMappings(out);
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int id = 0;
        int maxLine = 0;
        for (Mapping m : this.mappings) {
            if (!m.used) continue;
            m.id = id++;
            int endPositionLine = m.endPosition.getLine();
            maxLine = Math.max(maxLine, endPositionLine);
        }
        return maxLine + this.prefixPosition.getLine();
    }

    @Override
    public void validate(boolean validate) {
    }

    @Override
    public void appendIndexMapTo(Appendable out, String name, List<SourceMapSection> appSections) {
        throw new UnsupportedOperationException();
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor v) throws IOException {
            ArrayDeque<Mapping> stack = new ArrayDeque<Mapping>();
            for (Mapping m : SourceMapGeneratorV1.this.mappings) {
                while (!stack.isEmpty() && !this.isOverlapped((Mapping)stack.peek(), m)) {
                    Mapping previous = (Mapping)stack.pop();
                    this.maybeVisit(v, previous);
                }
                Mapping parent = (Mapping)stack.peek();
                this.maybeVisitParent(v, parent, m);
                stack.push(m);
            }
            while (!stack.isEmpty()) {
                Mapping m = (Mapping)stack.pop();
                this.maybeVisit(v, m);
            }
        }

        private int getAdjustedLine(FilePosition p) {
            return p.getLine() + SourceMapGeneratorV1.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition p) {
            int rawLine = p.getLine();
            int rawCol = p.getColumn();
            return rawLine != 0 ? rawCol : rawCol + SourceMapGeneratorV1.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping m1, Mapping m2) {
            int l1 = m1.endPosition.getLine();
            int l2 = m2.startPosition.getLine();
            int c1 = m1.endPosition.getColumn();
            int c2 = m2.startPosition.getColumn();
            return l1 == l2 && c1 >= c2 || l1 > l2;
        }

        private void maybeVisit(MappingVisitor v, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.endPosition);
            int nextCol = this.getAdjustedCol(m.endPosition);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, m, nextLine, nextCol);
            }
        }

        private void maybeVisitParent(MappingVisitor v, Mapping parent, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.startPosition);
            int nextCol = this.getAdjustedCol(m.startPosition);
            Preconditions.checkState((this.line < nextLine || this.col <= nextCol ? 1 : 0) != 0);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, parent, nextLine, nextCol);
            }
        }

        private void visit(MappingVisitor v, Mapping m, int nextLine, int nextCol) throws IOException {
            Preconditions.checkState((this.line <= nextLine ? 1 : 0) != 0);
            Preconditions.checkState((this.line < nextLine || this.col < nextCol ? 1 : 0) != 0);
            if (this.line == nextLine && this.col == nextCol) {
                Preconditions.checkState((boolean)false);
                return;
            }
            v.visit(m, this.line, this.col, nextLine, nextCol);
            this.line = nextLine;
            this.col = nextCol;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            if (m != null) {
                m.used = true;
            }
        }
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private boolean firstChar = true;
        private static final String UNMAPPED_STRING = "-1";
        private int lastId = -1;
        private String lastIdString = "-1";

        LineMapper(Appendable out) {
            this.out = out;
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            int id;
            int n = id = m != null ? m.id : -1;
            if (this.lastId != id) {
                this.lastIdString = id == -1 ? UNMAPPED_STRING : String.valueOf(id);
                this.lastId = id;
            }
            String idString = this.lastIdString;
            for (int i = line; i <= nextLine; ++i) {
                if (i == nextLine) {
                    for (int j = col; j < nextCol; ++j) {
                        this.addCharEntry(idString);
                    }
                    break;
                }
                this.closeLine();
                this.openLine();
                col = 0;
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine();
            new MappingTraversal().traverse(this);
            this.closeLine();
        }

        private void openLine() throws IOException {
            if (this.out != null) {
                this.out.append("[");
                this.firstChar = true;
            }
        }

        private void closeLine() throws IOException {
            if (this.out != null) {
                this.out.append("]\n");
            }
        }

        private void addCharEntry(String id) throws IOException {
            if (this.out != null) {
                if (this.firstChar) {
                    this.firstChar = false;
                } else {
                    this.out.append(",");
                }
                this.out.append(id);
            }
        }
    }

    private class MappingWriter {
        private String lastSourceFile = null;
        private String lastSourceFileEscaped = null;
        private int lastLine = 0;
        private String lastLineString = String.valueOf(0);

        private MappingWriter() {
        }

        private void appendMappingTo(Mapping m, Appendable out) throws IOException {
            out.append("[");
            String sourceFile = m.sourceFile;
            if (this.lastSourceFile != sourceFile) {
                this.lastSourceFile = sourceFile;
                this.lastSourceFileEscaped = SourceMapGeneratorV1.escapeString(sourceFile);
            }
            String escapedSourceFile = this.lastSourceFileEscaped;
            out.append(escapedSourceFile);
            out.append(",");
            int line = m.originalPosition.getLine();
            if (line != this.lastLine) {
                this.lastLineString = String.valueOf(line);
            }
            String lineValue = this.lastLineString;
            out.append(lineValue);
            out.append(",");
            out.append(String.valueOf(m.originalPosition.getColumn()));
            if (m.originalName != null) {
                out.append(",");
                out.append(SourceMapGeneratorV1.escapeString(m.originalName));
            }
            out.append("]\n");
        }

        void appendMappings(Appendable out) throws IOException {
            for (Mapping m : SourceMapGeneratorV1.this.mappings) {
                if (!m.used) continue;
                this.appendMappingTo(m, out);
            }
        }
    }

    static class Mapping {
        int id = -1;
        String sourceFile;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }
}

