/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.internal.Errors;
import com.google.inject.servlet.DefaultFilterPipeline;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.ManagedFilterPipeline;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GuiceFilter
implements Filter {
    static final ThreadLocal<Context> localContext = new ThreadLocal();
    static volatile FilterPipeline pipeline = new DefaultFilterPipeline();
    private final FilterPipeline injectedPipeline;
    static volatile WeakReference<ServletContext> servletContext = new WeakReference<Object>(null);
    private static final String MULTIPLE_INJECTORS_WARNING;
    private static final Logger LOGGER;

    public GuiceFilter() {
        this(null);
    }

    @Inject
    GuiceFilter(FilterPipeline filterPipeline) {
        this.injectedPipeline = filterPipeline;
    }

    @Inject
    static void setPipeline(FilterPipeline pipeline) {
        if (GuiceFilter.pipeline instanceof ManagedFilterPipeline) {
            LOGGER.warning(MULTIPLE_INJECTORS_WARNING);
        }
        GuiceFilter.pipeline = pipeline;
    }

    static void reset() {
        pipeline = new DefaultFilterPipeline();
        localContext.remove();
    }

    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain) throws IOException, ServletException {
        final FilterPipeline filterPipeline = this.getFilterPipeline();
        Context previous = localContext.get();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest originalRequest = previous != null ? previous.getOriginalRequest() : request;
        try {
            new Context(originalRequest, request, response).call(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    filterPipeline.dispatch(servletRequest, servletResponse, filterChain);
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    static HttpServletRequest getOriginalRequest(Key<?> key) {
        return GuiceFilter.getContext(key).getOriginalRequest();
    }

    static HttpServletRequest getRequest(Key<?> key) {
        return GuiceFilter.getContext(key).getRequest();
    }

    static HttpServletResponse getResponse(Key<?> key) {
        return GuiceFilter.getContext(key).getResponse();
    }

    static ServletContext getServletContext() {
        return (ServletContext)servletContext.get();
    }

    private static Context getContext(Key<?> key) {
        Context context = localContext.get();
        if (context == null) {
            String string = String.valueOf(String.valueOf(Errors.convert(key)));
            String string2 = String.valueOf(String.valueOf(GuiceFilter.class.getName()));
            throw new OutOfScopeException(new StringBuilder(158 + string.length() + string2.length()).append("Cannot access scoped [").append(string).append("]. Either we are not currently inside an HTTP Servlet request, or you may").append(" have forgotten to apply ").append(string2).append(" as a servlet filter for this request.").toString());
        }
        return context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        GuiceFilter.servletContext = new WeakReference<ServletContext>(servletContext);
        FilterPipeline filterPipeline = this.getFilterPipeline();
        filterPipeline.initPipeline(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            FilterPipeline filterPipeline = this.getFilterPipeline();
            filterPipeline.destroyPipeline();
        }
        finally {
            GuiceFilter.reset();
            servletContext.clear();
        }
    }

    private FilterPipeline getFilterPipeline() {
        return null != this.injectedPipeline ? this.injectedPipeline : pipeline;
    }

    static {
        String string = String.valueOf(String.valueOf("Multiple Servlet injectors detected. This is a warning indicating that you have more than one "));
        String string2 = String.valueOf(String.valueOf(GuiceFilter.class.getSimpleName()));
        MULTIPLE_INJECTORS_WARNING = new StringBuilder(170 + string.length() + string2.length()).append(string).append(string2).append(" running ").append("in your web application. If this is deliberate, you may safely ").append("ignore this message. If this is NOT deliberate however, ").append("your application may not work as expected.").toString();
        LOGGER = Logger.getLogger(GuiceFilter.class.getName());
    }

    static class Context {
        final HttpServletRequest originalRequest;
        final HttpServletRequest request;
        final HttpServletResponse response;

        Context(HttpServletRequest originalRequest, HttpServletRequest request, HttpServletResponse response) {
            this.originalRequest = originalRequest;
            this.request = request;
            this.response = response;
        }

        HttpServletRequest getOriginalRequest() {
            return this.originalRequest;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        HttpServletResponse getResponse() {
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized <T> T call(Callable<T> callable) throws Exception {
            Context previous = localContext.get();
            localContext.set(this);
            try {
                T t = callable.call();
                return t;
            }
            finally {
                localContext.set(previous);
            }
        }
    }
}

