/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.AttachDetachException;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RootPanel
extends AbsolutePanel {
    private static final AttachDetachException.Command maybeDetachCommand = new AttachDetachException.Command(){

        @Override
        public void execute(Widget w) {
            if (w.isAttached()) {
                w.onDetach();
            }
        }
    };
    private static Map<String, RootPanel> rootPanels = new HashMap<String, RootPanel>();
    private static Set<Widget> widgetsToDetach = new HashSet<Widget>();

    public static void detachNow(Widget widget) {
        assert (widgetsToDetach.contains(widget)) : "detachNow() called on a widget not currently in the detach list";
        try {
            widget.onDetach();
        }
        finally {
            widgetsToDetach.remove(widget);
        }
    }

    public static void detachOnWindowClose(Widget widget) {
        assert (!widgetsToDetach.contains(widget)) : "detachOnUnload() called twice for the same widget";
        assert (!RootPanel.isElementChildOfWidget(widget.getElement())) : "A widget that has an existing parent widget may not be added to the detach list";
        widgetsToDetach.add(widget);
    }

    public static RootPanel get() {
        return RootPanel.get(null);
    }

    public static RootPanel get(String id) {
        RootPanel rp = rootPanels.get(id);
        com.google.gwt.dom.client.Element elem = null;
        if (id != null && null == (elem = Document.get().getElementById(id))) {
            return null;
        }
        if (rp != null && (elem == null || rp.getElement() == elem)) {
            return rp;
        }
        if (rootPanels.size() == 0) {
            RootPanel.hookWindowClosing();
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                BidiUtils.setDirectionOnElement(RootPanel.getRootElement(), HasDirection.Direction.RTL);
            }
        }
        rp = elem == null ? new DefaultRootPanel() : new RootPanel(elem);
        rootPanels.put(id, rp);
        RootPanel.detachOnWindowClose(rp);
        return rp;
    }

    public static native Element getBodyElement();

    public static boolean isInDetachList(Widget widget) {
        return widgetsToDetach.contains(widget);
    }

    static void detachWidgets() {
        try {
            AttachDetachException.tryCommand(widgetsToDetach, maybeDetachCommand);
        }
        finally {
            widgetsToDetach.clear();
            rootPanels.clear();
        }
    }

    private static native com.google.gwt.dom.client.Element getRootElement();

    private static void hookWindowClosing() {
        Window.addCloseHandler(new CloseHandler<Window>(){

            @Override
            public void onClose(CloseEvent<Window> closeEvent) {
                RootPanel.detachWidgets();
            }
        });
    }

    private static boolean isElementChildOfWidget(com.google.gwt.dom.client.Element element) {
        element = element.getParentElement();
        BodyElement body = Document.get().getBody();
        while (element != null && body != element) {
            if (Event.getEventListener(element) != null) {
                return true;
            }
            element = (com.google.gwt.dom.client.Element)element.getParentElement().cast();
        }
        return false;
    }

    private RootPanel(com.google.gwt.dom.client.Element elem) {
        super(elem);
        this.onAttach();
    }

    public void clear(boolean clearDom) {
        this.clear();
        if (clearDom) {
            this.getElement().removeAllChildren();
        }
    }

    private static class DefaultRootPanel
    extends RootPanel {
        public DefaultRootPanel() {
            super(DefaultRootPanel.getBodyElement());
        }

        @Override
        protected void setWidgetPositionImpl(Widget w, int left, int top) {
            super.setWidgetPositionImpl(w, left -= Document.get().getBodyOffsetLeft(), top -= Document.get().getBodyOffsetTop());
        }
    }
}

