/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.Options;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.tools.JavaFileObject;

public abstract class Dependencies {
    protected static final Context.Key<Dependencies> dependenciesKey = new Context.Key();

    public static Dependencies instance(Context context) {
        Dependencies instance = context.get(dependenciesKey);
        if (instance == null) {
            instance = new DummyDependencies(context);
        }
        return instance;
    }

    Dependencies(Context context) {
        context.put(dependenciesKey, this);
    }

    public abstract void push(Symbol.ClassSymbol var1);

    public abstract void push(AttributionKind var1, JCTree var2);

    public abstract void pop();

    private static class DummyDependencies
    extends Dependencies {
        private DummyDependencies(Context context) {
            super(context);
        }

        @Override
        public void push(Symbol.ClassSymbol s) {
        }

        @Override
        public void push(AttributionKind ak, JCTree t) {
        }

        @Override
        public void pop() {
        }
    }

    public static class GraphDependencies
    extends Dependencies
    implements Closeable,
    Symbol.Completer {
        private EnumSet<DependenciesMode> dependenciesModes;
        private String dependenciesFile;
        Stack<Node> nodeStack = new Stack();
        Map<String, Node> dependencyNodeMap = new LinkedHashMap<String, Node>();

        public static void preRegister(final Context context) {
            context.put(dependenciesKey, new Context.Factory<Dependencies>(){

                @Override
                public Dependencies make(Context c) {
                    GraphDependencies deps = new GraphDependencies(context);
                    return deps;
                }
            });
        }

        GraphDependencies(Context context) {
            super(context);
            String[] modes;
            Options options = Options.instance(context);
            for (String mode : modes = options.get("completionDeps").split(",")) {
                if (!mode.startsWith("file=")) continue;
                this.dependenciesFile = mode.substring(5);
            }
            this.dependenciesModes = DependenciesMode.getDependenciesModes(modes);
            JavaCompiler compiler2 = JavaCompiler.instance(context);
            compiler2.closeables = compiler2.closeables.prepend(this);
        }

        @Override
        public void push(Symbol.ClassSymbol s) {
            CompletionNode n = new CompletionNode(s);
            if (n == this.push(n)) {
                s.completer = this;
            }
        }

        @Override
        public void push(AttributionKind ak, JCTree t) {
            this.push(new AttributionNode(ak, t));
        }

        protected Node push(Node newNode) {
            Node cachedNode = this.dependencyNodeMap.get(newNode.data);
            if (cachedNode == null) {
                this.dependencyNodeMap.put((String)newNode.data, newNode);
            } else {
                newNode = cachedNode;
            }
            if (!this.nodeStack.isEmpty()) {
                Node currentNode = this.nodeStack.peek();
                currentNode.addDependency(Node.DependencyKind.REQUIRES, newNode);
            }
            this.nodeStack.push(newNode);
            return newNode;
        }

        @Override
        public void pop() {
            this.nodeStack.pop();
        }

        @Override
        public void close() throws IOException {
            if (this.dependenciesFile != null) {
                if (!this.dependenciesModes.contains((Object)DependenciesMode.REDUNDANT)) {
                    new PruneVisitor().visit(this.dependencyNodeMap.values(), null);
                }
                if (!this.dependenciesModes.contains((Object)DependenciesMode.CLASS)) {
                    new FilterVisitor(CompletionNode.Kind.SOURCE).visit(this.dependencyNodeMap.values(), null);
                }
                if (!this.dependenciesModes.contains((Object)DependenciesMode.SOURCE)) {
                    new FilterVisitor(CompletionNode.Kind.CLASS).visit(this.dependencyNodeMap.values(), null);
                }
                if (this.dependenciesModes.contains((Object)DependenciesMode.SIDE_EFFECTS)) {
                    new SideEffectVisitor().visit(this.dependencyNodeMap.values(), null);
                }
                try (FileWriter fw = new FileWriter(this.dependenciesFile);){
                    fw.append(GraphUtils.toDot(this.dependencyNodeMap.values(), "CompletionDeps", ""));
                }
            }
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            this.push((Symbol.ClassSymbol)sym);
            this.pop();
            sym.completer = this;
        }

        private class FilterVisitor
        extends GraphUtils.NodeVisitor<String, Node, Void> {
            CompletionNode.Kind ck;

            private FilterVisitor(CompletionNode.Kind ck) {
                this.ck = ck;
            }

            @Override
            public void visitNode(Node node, Void arg) {
                if (node instanceof CompletionNode && ((CompletionNode)node).ck != this.ck) {
                    GraphDependencies.this.dependencyNodeMap.remove(node.data);
                }
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dk, Node from, Node to, Void arg) {
                if (to instanceof CompletionNode && ((CompletionNode)to).ck != this.ck) {
                    from.depsByKind.get(dk).remove(to);
                }
            }
        }

        private static class PruneVisitor
        extends GraphUtils.NodeVisitor<String, Node, Void> {
            private PruneVisitor() {
            }

            @Override
            public void visitNode(Node node, Void arg) {
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dk, Node from, Node to, Void arg) {
                if (from.equals(to) || from.depsByKind.get(Node.DependencyKind.REQUIRES).contains(to)) {
                    to.depsByKind.get(dk).remove(from);
                }
            }
        }

        private static class SideEffectVisitor
        extends GraphUtils.NodeVisitor<String, Node, Void> {
            private SideEffectVisitor() {
            }

            @Override
            public void visitNode(Node node, Void arg) {
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dk, Node from, Node to, Void arg) {
                List<Node> deps = from.depsByKind.get(dk);
                int pos = deps.indexOf(to);
                if (dk == Node.DependencyKind.REQUIRES && pos > 0) {
                    to.addDependency(Node.DependencyKind.SIDE_EFFECTS, deps.get(pos - 1));
                }
            }
        }

        static class AttributionNode
        extends Node {
            AttributionNode(AttributionKind ak, JCTree tree) {
                super(ak.format(tree));
            }

            @Override
            public Properties nodeAttributes() {
                Properties p = super.nodeAttributes();
                p.put("shape", "box");
                p.put("style", "solid");
                return p;
            }
        }

        static class CompletionNode
        extends Node {
            final Kind ck;

            CompletionNode(Symbol.ClassSymbol sym) {
                super(sym.getQualifiedName().toString());
                boolean fromClass = sym.classfile == null && sym.sourcefile == null || sym.classfile != null && sym.classfile.getKind() == JavaFileObject.Kind.CLASS;
                this.ck = fromClass ? Kind.CLASS : Kind.SOURCE;
            }

            @Override
            public Properties nodeAttributes() {
                Properties p = super.nodeAttributes();
                p.put("style", this.ck.dotStyle);
                p.put("shape", "ellipse");
                return p;
            }

            static enum Kind {
                SOURCE("solid"),
                CLASS("dotted");

                final String dotStyle;

                private Kind(String dotStyle) {
                    this.dotStyle = dotStyle;
                }
            }
        }

        static abstract class Node
        extends GraphUtils.AbstractNode<String, Node>
        implements GraphUtils.DottableNode<String, Node> {
            EnumMap<DependencyKind, List<Node>> depsByKind = new EnumMap(DependencyKind.class);

            Node(String value) {
                super(value);
                for (DependencyKind depKind : DependencyKind.values()) {
                    this.depsByKind.put(depKind, new ArrayList());
                }
            }

            void addDependency(DependencyKind depKind, Node dep) {
                List<Node> deps = this.depsByKind.get(depKind);
                if (!deps.contains(dep)) {
                    deps.add(dep);
                }
            }

            public boolean equals(Object obj) {
                return obj instanceof Node && ((String)this.data).equals(((Node)obj).data);
            }

            public int hashCode() {
                return ((String)this.data).hashCode();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return DependencyKind.values();
            }

            @Override
            public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dk) {
                List<Node> deps = this.depsByKind.get(dk);
                if (dk == DependencyKind.REQUIRES) {
                    return deps;
                }
                HashSet<Node> temp = new HashSet<Node>(deps);
                temp.removeAll((Collection)this.depsByKind.get(DependencyKind.REQUIRES));
                return temp;
            }

            @Override
            public Properties nodeAttributes() {
                Properties p = new Properties();
                p.put("label", GraphUtils.DotVisitor.wrap(this.toString()));
                return p;
            }

            @Override
            public Properties dependencyAttributes(Node to, GraphUtils.DependencyKind dk) {
                Properties p = new Properties();
                p.put("style", ((DependencyKind)dk).dotStyle);
                return p;
            }

            static enum DependencyKind implements GraphUtils.DependencyKind
            {
                REQUIRES("solid"),
                SIDE_EFFECTS("dashed");

                final String dotStyle;

                private DependencyKind(String dotStyle) {
                    this.dotStyle = dotStyle;
                }
            }
        }

        static enum DependenciesMode {
            SOURCE("source"),
            CLASS("class"),
            REDUNDANT("redundant"),
            SIDE_EFFECTS("side-effects");

            final String opt;

            private DependenciesMode(String opt) {
                this.opt = opt;
            }

            static EnumSet<DependenciesMode> getDependenciesModes(String[] modes) {
                EnumSet<DependenciesMode> res = EnumSet.noneOf(DependenciesMode.class);
                List<String> args = Arrays.asList(modes);
                if (args.contains("all")) {
                    res = EnumSet.allOf(DependenciesMode.class);
                }
                for (DependenciesMode mode : DependenciesMode.values()) {
                    if (args.contains(mode.opt)) {
                        res.add(mode);
                        continue;
                    }
                    String string = String.valueOf(mode.opt);
                    if (!args.contains(string.length() != 0 ? "-".concat(string) : new String("-"))) continue;
                    res.remove((Object)mode);
                }
                return res;
            }
        }
    }

    public static enum AttributionKind {
        EXTENDS{

            @Override
            String format(JCTree tree) {
                String string = String.valueOf(super.format(tree));
                return string.length() != 0 ? "extends ".concat(string) : new String("extends ");
            }
        }
        ,
        IMPLEMENTS{

            @Override
            String format(JCTree tree) {
                String string = String.valueOf(super.format(tree));
                return string.length() != 0 ? "implements ".concat(string) : new String("implements ");
            }
        }
        ,
        IMPORT,
        TVAR{

            @Override
            String format(JCTree tree) {
                String string = String.valueOf(String.valueOf(super.format(tree)));
                return new StringBuilder(2 + string.length()).append("<").append(string).append(">").toString();
            }
        };


        String format(JCTree tree) {
            return tree.toString();
        }
    }
}

