/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.firestore;

import com.google.cloud.spring.core.Credentials;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.GcpScope;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.cloud.gcp.firestore")
public class GcpFirestoreProperties
implements CredentialsSupplier {
    private static final String ROOT_PATH_FORMAT = "projects/%s/databases/%s/documents";
    @NestedConfigurationProperty
    private final Credentials credentials = new Credentials(new String[]{GcpScope.DATASTORE.getUrl()});
    private String projectId;
    private String databaseId;
    private String hostPort = "firestore.googleapis.com:443";
    @NestedConfigurationProperty
    private FirestoreEmulatorProperties emulator = new FirestoreEmulatorProperties();

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getResolvedProjectId(GcpProjectIdProvider projectIdProvider) {
        return this.getProjectId() != null ? this.getProjectId() : projectIdProvider.getProjectId();
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getResolvedDatabaseId() {
        return this.getDatabaseId() == null ? "(default)" : this.getDatabaseId();
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public FirestoreEmulatorProperties getEmulator() {
        return this.emulator;
    }

    public void setEmulator(FirestoreEmulatorProperties emulator) {
        this.emulator = emulator;
    }

    public String getFirestoreRootPath(GcpProjectIdProvider projectIdProvider) {
        return String.format(ROOT_PATH_FORMAT, this.getResolvedProjectId(projectIdProvider), this.getResolvedDatabaseId());
    }

    public static class FirestoreEmulatorProperties {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

