/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;

public class TraceLoggingEnhancer
implements LoggingEnhancer {
    private static final ThreadLocal<String> traceId = new ThreadLocal();
    private static final ThreadLocal<String> spanId = new ThreadLocal();
    private static final ThreadLocal<Boolean> traceSampled = new ThreadLocal();

    public TraceLoggingEnhancer() {
    }

    public TraceLoggingEnhancer(String prefix) {
    }

    public static void setCurrentTraceId(String id) {
        if (id == null) {
            traceId.remove();
        } else {
            traceId.set(id);
        }
    }

    public static void setCurrentSpanId(String id) {
        if (id == null) {
            spanId.remove();
        } else {
            spanId.set(id);
        }
    }

    public static void setCurrentTraceSampled(Boolean isTraceSampled) {
        if (isTraceSampled == null) {
            traceSampled.remove();
        } else {
            traceSampled.set(isTraceSampled);
        }
    }

    public static String getCurrentTraceId() {
        return traceId.get();
    }

    public static String getCurrentSpanId() {
        return spanId.get();
    }

    public static Boolean getCurrentTraceSampled() {
        return traceSampled.get();
    }

    @Override
    public void enhanceLogEntry(LogEntry.Builder builder) {
        Boolean isTraceSampled;
        String spanId;
        String traceId = TraceLoggingEnhancer.getCurrentTraceId();
        if (traceId != null) {
            builder.setTrace(traceId);
        }
        if ((spanId = TraceLoggingEnhancer.getCurrentSpanId()) != null) {
            builder.setSpanId(spanId);
        }
        if ((isTraceSampled = TraceLoggingEnhancer.getCurrentTraceSampled()) != null) {
            builder.setTraceSampled(isTraceSampled);
        }
    }
}

