/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import org.slf4j.MDC;

public class TraceLoggingEventEnhancer
implements LoggingEventEnhancer {
    private static final String TRACE_ID = "logging.googleapis.trace";

    public static void setCurrentTraceId(String id) {
        MDC.put((String)TRACE_ID, (String)id);
    }

    public static void clearTraceId() {
        MDC.remove((String)TRACE_ID);
    }

    public static String getCurrentTraceId() {
        return MDC.get((String)TRACE_ID);
    }

    @Override
    public void enhanceLogEntry(LogEntry.Builder builder, ILoggingEvent e) {
        String traceId;
        Object value = e.getMDCPropertyMap().get(TRACE_ID);
        String string = traceId = value != null ? value.toString() : null;
        if (traceId != null) {
            builder.setTrace(traceId);
        }
    }
}

