/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.manager;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.ibu.MigrationContext;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuAutorisation;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurDuplicated;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurGPS;
import com.cybelia.sandra.ibu.csv.bean.IbuEvent;
import com.cybelia.sandra.ibu.csv.bean.IbuLabel;
import com.cybelia.sandra.ibu.csv.bean.IbuTransporteur;
import com.cybelia.sandra.ibu.csv.bean.IbuUser;
import com.cybelia.sandra.ibu.csv.bean.IbuUsine;
import com.cybelia.sandra.ibu.injector.InjectorAutorisation;
import com.cybelia.sandra.ibu.injector.InjectorCamion;
import com.cybelia.sandra.ibu.injector.InjectorChauffeur;
import com.cybelia.sandra.ibu.injector.InjectorCommande;
import com.cybelia.sandra.ibu.injector.InjectorEleveur;
import com.cybelia.sandra.ibu.injector.InjectorEleveurDuplicated;
import com.cybelia.sandra.ibu.injector.InjectorEleveurGPS;
import com.cybelia.sandra.ibu.injector.InjectorEtape;
import com.cybelia.sandra.ibu.injector.InjectorEvent;
import com.cybelia.sandra.ibu.injector.InjectorInfoChargement;
import com.cybelia.sandra.ibu.injector.InjectorLabel;
import com.cybelia.sandra.ibu.injector.InjectorLigneProduit;
import com.cybelia.sandra.ibu.injector.InjectorSociete;
import com.cybelia.sandra.ibu.injector.InjectorTour;
import com.cybelia.sandra.ibu.injector.InjectorTransporteur;
import com.cybelia.sandra.ibu.injector.InjectorUser;
import com.cybelia.sandra.ibu.injector.InjectorUsine;
import com.cybelia.sandra.ibu.manager.Injector;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;
import org.nuiton.util.CallAnalyse;

public class ManagerInjector {
    private final Log log = LogFactory.getLog(ManagerInjector.class);
    protected TopiaContext rootContext;
    protected TopiaContext transaction;
    protected Map<String, Injector> injectors = new TreeMap<String, Injector>();
    protected List<Eleveur> createdEleveurs;

    public TopiaContext getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TopiaContext transaction) {
        this.transaction = transaction;
    }

    public void setRootContext(TopiaContext rootContext) {
        this.rootContext = rootContext;
    }

    public TopiaContext getRootContext() throws IOException, TopiaNotFoundException {
        if (this.rootContext == null) {
            this.rootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
        }
        return this.rootContext;
    }

    public ManagerInjector() {
        for (InjectorsInstances injector : InjectorsInstances.values()) {
            this.injectors.put(injector.name(), injector.getInstance());
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("load [" + injector.name() + "]"));
        }
        this.createdEleveurs = Lists.newArrayList();
    }

    public void addCreatedEleveur(Eleveur createdEleveur) {
        this.createdEleveurs.add(createdEleveur);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.getRootContext().isClosed()) return;
        }
        catch (Exception e) {
            this.log.fatal((Object)"Injector error", (Throwable)e);
            throw new RuntimeException("Error closing connection", e);
        }
    }

    public <T extends Injector> T getInjector(Class<T> klass) {
        return (T)this.injectors.get(klass.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectIbus(MigrationContext contextMigration, List<Ibu> ibus) {
        block53: {
            try {
                this.transaction = this.getRootContext().beginTransaction();
                this.transaction.rollbackTransaction();
            }
            catch (Exception e) {
                this.log.fatal((Object)"Injector error", (Throwable)e);
                throw new RuntimeException("Error opening connection", e);
            }
            finally {
                try {
                    this.transaction.closeContext();
                }
                catch (TopiaException ex) {
                    this.log.error((Object)"Cant close context", (Throwable)ex);
                }
            }
            int lineNumber = 0;
            InjectorCommande injectorCommande = this.getInjector(InjectorCommande.class);
            InjectorSociete injectorSociete = this.getInjector(InjectorSociete.class);
            InjectorUsine injectorUsine = this.getInjector(InjectorUsine.class);
            InjectorCamion injectorCamion = this.getInjector(InjectorCamion.class);
            InjectorInfoChargement injectorInfoChargement = this.getInjector(InjectorInfoChargement.class);
            InjectorChauffeur injectorChauffeur = this.getInjector(InjectorChauffeur.class);
            InjectorTransporteur injectorTransporteur = this.getInjector(InjectorTransporteur.class);
            InjectorEleveur injectorEleveur = this.getInjector(InjectorEleveur.class);
            InjectorTour injectorTour = this.getInjector(InjectorTour.class);
            InjectorEtape injectorEtape = this.getInjector(InjectorEtape.class);
            InjectorLigneProduit injectorLigneProduit = this.getInjector(InjectorLigneProduit.class);
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Begin transaction...");
                }
                this.transaction = this.getRootContext().beginTransaction();
                for (Ibu ibu : ibus) {
                    ++lineNumber;
                    if (ibu == null) continue;
                    String step = "init";
                    try {
                        this.clearInjectors();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)ibu);
                        }
                        this.log.info((Object)("Commande [" + ibu.getCommandeCode() + "] camion [" + ibu.getCamionCodeSociete() + "] tour [" + ibu.getTourNumero() + "] date [" + ibu.getTourDateLivraison() + "]"));
                        step = "injectorCommande";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject commande ...");
                        }
                        injectorCommande.inject(this, ibu);
                        step = "injectorSociete";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject societe...");
                        }
                        injectorSociete.inject(this, ibu);
                        step = "injectorUsine";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject usine...");
                        }
                        injectorUsine.inject(this, ibu);
                        step = "injectorEleveur";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject eleveur...");
                        }
                        injectorEleveur.inject(this, ibu);
                        step = "injectorLigneProduit";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject ligne produit...");
                        }
                        injectorLigneProduit.inject(this, ibu);
                        step = "injectorCamion";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject camion...");
                        }
                        injectorCamion.inject(this, ibu);
                        step = "injectorChauffeur";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject chauffeur...");
                        }
                        injectorChauffeur.inject(this, ibu);
                        step = "injectorTransporteur";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject transporteur...");
                        }
                        injectorTransporteur.inject(this, ibu);
                        step = "injectorTour";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject tour...");
                        }
                        injectorTour.inject(this, ibu);
                        step = "injectorEtape";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject etape...");
                        }
                        injectorEtape.inject(this, ibu);
                        step = "injectorInfoChargement";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject info chargement...");
                        }
                        injectorInfoChargement.inject(this, ibu);
                        step = "injectCamionUser";
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Inject camion user...");
                        }
                        this.injectCamionUser(contextMigration);
                    }
                    catch (Exception eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("injectIbus error. Step is: " + step), (Throwable)eee);
                        }
                        contextMigration.addErrorMsg(eee.getMessage());
                        contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                        throw eee;
                    }
                    finally {
                        try {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)"Commit transaction...");
                            }
                            this.transaction.commitTransaction();
                            SandraHelper.checkDuplicateBreeder(this.transaction, this.createdEleveurs, "ibuEleveurCreation");
                            this.createdEleveurs.clear();
                        }
                        catch (TopiaException ex) {
                            this.log.error((Object)"Cant commit transaction", (Throwable)ex);
                        }
                    }
                }
            }
            catch (Exception eee) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"injectIbus error", (Throwable)eee);
                }
                contextMigration.addErrorMsg(eee.getMessage());
                contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                if (this.transaction == null) break block53;
                try {
                    if (!this.transaction.isClosed()) {
                        this.transaction.rollbackTransaction();
                        this.transaction.closeContext();
                    }
                }
                catch (TopiaException te) {
                    this.log.error((Object)"Error during Rollback. Data may not be integrated correctly", (Throwable)te);
                }
            }
            finally {
                try {
                    Date now = new Date();
                    if (!this.transaction.isClosed()) {
                        this.transaction.closeContext();
                    }
                    Date after = new Date();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Time between log and close context : " + ManagerInjector.getDifferenceInMilliSeconds(now, after) + "ms"));
                    }
                }
                catch (TopiaException ex) {
                    this.log.error((Object)"Cant commit transaction", (Throwable)ex);
                }
            }
        }
    }

    public static int getDifferenceInMilliSeconds(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil(end - begin);
    }

    public void injectUsines(MigrationContext contextMigration, List<IbuUsine> usines) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorUsine injectorUsine = this.getInjector(InjectorUsine.class);
            int lineNumber = 0;
            for (IbuUsine usine : usines) {
                ++lineNumber;
                if (usine == null) continue;
                try {
                    this.log.info((Object)usine);
                    this.log.info((Object)"Inject usine ...");
                    injectorUsine.inject(this, usine);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectUsines error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectCamions(MigrationContext contextMigration, List<IbuCamion> camions) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorSociete injectorSociete = this.getInjector(InjectorSociete.class);
            InjectorCamion injectorCamion = this.getInjector(InjectorCamion.class);
            InjectorTransporteur injectorTransporteur = this.getInjector(InjectorTransporteur.class);
            int lineNumber = 0;
            for (IbuCamion camion : camions) {
                ++lineNumber;
                if (camion == null) continue;
                try {
                    this.log.info((Object)camion);
                    this.log.info((Object)"Inject societe ...");
                    injectorSociete.inject(this, camion);
                    this.log.info((Object)"Inject transporteur ...");
                    injectorTransporteur.inject(this, camion);
                    this.log.info((Object)"Inject camion ...");
                    injectorCamion.inject(this, camion);
                    this.log.info((Object)"Inject camion user ...");
                    this.injectCamionUser(contextMigration);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectCamions error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectChauffeurs(MigrationContext contextMigration, List<IbuChauffeur> chauffeurs) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorSociete injectorSociete = this.getInjector(InjectorSociete.class);
            InjectorChauffeur injectorChauffeur = this.getInjector(InjectorChauffeur.class);
            int lineNumber = 0;
            for (IbuChauffeur chauffeur : chauffeurs) {
                ++lineNumber;
                if (chauffeur == null) continue;
                try {
                    this.log.info((Object)chauffeur);
                    this.log.info((Object)"Inject societe ...");
                    injectorSociete.inject(this, chauffeur);
                    this.log.info((Object)"Inject chauffeur ...");
                    injectorChauffeur.inject(this, chauffeur);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectChauffeurs error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectTransporteurs(MigrationContext contextMigration, List<IbuTransporteur> transporteurs) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorSociete injectorSociete = this.getInjector(InjectorSociete.class);
            InjectorTransporteur injectorTransporteur = this.getInjector(InjectorTransporteur.class);
            int lineNumber = 0;
            for (IbuTransporteur transporteur : transporteurs) {
                ++lineNumber;
                if (transporteur == null) continue;
                try {
                    this.log.info((Object)transporteur);
                    this.log.info((Object)"Inject societe ...");
                    injectorSociete.inject(this, transporteur);
                    this.log.info((Object)"Inject transporteur ...");
                    injectorTransporteur.inject(this, transporteur);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectTransporteurs error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectAutorisations(MigrationContext contextMigration, List<IbuAutorisation> data) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorAutorisation injector = this.getInjector(InjectorAutorisation.class);
            int lineNumber = 0;
            for (IbuAutorisation event : data) {
                ++lineNumber;
                if (event == null) continue;
                try {
                    this.log.info((Object)event);
                    this.log.info((Object)"Inject autorisation ...");
                    injector.inject(this, event);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectAutorisations error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectUsers(MigrationContext contextMigration, List<IbuUser> data) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorUser injector = this.getInjector(InjectorUser.class);
            int lineNumber = 0;
            for (IbuUser event : data) {
                ++lineNumber;
                if (event == null) continue;
                try {
                    this.log.info((Object)event);
                    this.log.info((Object)"Inject user ...");
                    injector.inject(this, event);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectUsers error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectCamionUsers(MigrationContext contextMigration) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            CamionDAO camionDAO = SandraDAOHelper.getCamionDAO((TopiaContext)this.transaction);
            List camions = camionDAO.findAll();
            for (Camion camion : camions) {
                this.injectCamionUser(camion);
                this.log.info((Object)("Inject user " + camion.getSociete().getCode() + "-" + camion.getCode() + " ... success"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectCamionUser(Camion camion) throws TopiaException {
        String login;
        String password = login = camion.getSociete().getCode() + "-" + camion.getCode();
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO((TopiaContext)this.getTransaction());
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO((TopiaContext)this.getTransaction());
        if (userDAO.findByLogin(login) == null && principalDAO.findByName(login) == null) {
            TaasUser user = (TaasUser)userDAO.create(new Object[0]);
            user.setLogin(login);
            user.setPassword(TaasUtil.hash((String)password));
            user.setEnabled(true);
            user.setLink(camion.getSociete().getTopiaId());
            this.log.info((Object)"Inject user ... success");
            SandraHelper.createUserIndicateurIfDontExist(this.getTransaction(), user);
            TaasPrincipal principal = (TaasPrincipal)principalDAO.create(new Object[0]);
            principal.setName(login);
            user.addPrincipals(principal);
            TaasPrincipal principalUser = principalDAO.findByName("synchro");
            user.addPrincipals(principalUser);
            this.log.info((Object)"Inject principal ... success");
        }
    }

    public void injectCamionUser(MigrationContext contextMigration) throws TopiaException {
        Camion camion = this.getCamion();
        this.injectCamionUser(camion);
    }

    public void injectLabels(MigrationContext contextMigration, List<IbuLabel> labels) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorLabel injector = this.getInjector(InjectorLabel.class);
            int lineNumber = 0;
            for (IbuLabel label : labels) {
                ++lineNumber;
                if (label == null) continue;
                try {
                    this.log.info((Object)label);
                    this.log.info((Object)"Inject label ...");
                    injector.inject(this, label);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectLabel error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectEvents(MigrationContext contextMigration, List<IbuEvent> events) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorEvent injector = this.getInjector(InjectorEvent.class);
            int lineNumber = 0;
            for (IbuEvent event : events) {
                ++lineNumber;
                try {
                    this.log.info((Object)event);
                    this.log.info((Object)"Inject event ...");
                    injector.inject(this, event);
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectEvent error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    public void injectEleveurGPS(MigrationContext contextMigration, List<IbuEleveurGPS> eleveurGPSs) {
        try {
            this.transaction = this.getRootContext().beginTransaction();
            InjectorEleveurGPS injector = this.getInjector(InjectorEleveurGPS.class);
            int lineNumber = 0;
            this.log.info((Object)"Inject eleveurGPS ...");
            for (IbuEleveurGPS eleveurGPS : eleveurGPSs) {
                ++lineNumber;
                try {
                    this.log.info((Object)eleveurGPS);
                    injector.inject(this, eleveurGPS);
                    injector.clear();
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectEvent error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.transaction.commitTransaction();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant commit transaction", (Throwable)ex);
            }
            try {
                this.transaction.closeContext();
            }
            catch (TopiaException ex) {
                this.log.error((Object)"Cant close context", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectEleveurDuplicated(MigrationContext contextMigration, List<IbuEleveurDuplicated> eleveurDuplicateds) {
        try {
            int lineNumber = 0;
            this.log.info((Object)"Inject eleveurDuplicated ...");
            for (IbuEleveurDuplicated eleveurDuplicated : eleveurDuplicateds) {
                ++lineNumber;
                try {
                    this.log.info((Object)eleveurDuplicated);
                    this.transaction = this.getRootContext().beginTransaction();
                    InjectorEleveurDuplicated injector = this.getInjector(InjectorEleveurDuplicated.class);
                    injector.inject(this, eleveurDuplicated);
                    injector.clear();
                }
                catch (Exception eee) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"injectEvent error", (Throwable)eee);
                    }
                    contextMigration.addErrorMsg(eee.getMessage());
                    contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                }
                finally {
                    try {
                        this.transaction.commitTransaction();
                    }
                    catch (TopiaException ex) {
                        this.log.error((Object)"Cant commit transaction", (Throwable)ex);
                    }
                    try {
                        this.transaction.closeContext();
                    }
                    catch (TopiaException ex) {
                        this.log.error((Object)"Cant close context", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Injector error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Usine getUsine() {
        return this.getInjector(InjectorUsine.class).getObject();
    }

    public Tour getTour() {
        return this.getInjector(InjectorTour.class).getObject();
    }

    public Camion getCamion() {
        return this.getInjector(InjectorCamion.class).getObject();
    }

    public Chauffeur getChauffeur() {
        return this.getInjector(InjectorChauffeur.class).getObject();
    }

    public Commande getCommande() {
        return this.getInjector(InjectorCommande.class).getObject();
    }

    public LigneProduit getLigneProduit() {
        return this.getInjector(InjectorLigneProduit.class).getObject();
    }

    public Eleveur getEleveur() {
        return this.getInjector(InjectorEleveur.class).getObject();
    }

    public InfoAccess getSilo() {
        return this.getInjector(InjectorEleveur.class).getSilo();
    }

    public Etape getEtape() {
        return this.getInjector(InjectorEtape.class).getObject();
    }

    public InfoChargement getInfoChargement() {
        return this.getInjector(InjectorInfoChargement.class).getObject();
    }

    public Societe getSociete() {
        return this.getInjector(InjectorSociete.class).getObject();
    }

    public Transporteur getTransporteur() {
        return this.getInjector(InjectorTransporteur.class).getObject();
    }

    public Label getLabel() {
        return this.getInjector(InjectorLabel.class).getObject();
    }

    public boolean isInfoChargementChanged() {
        return this.getInjector(InjectorInfoChargement.class).isInfoChargementChanged();
    }

    public boolean isCommandeCreated() {
        return this.getInjector(InjectorCommande.class).isCommandeCreated();
    }

    public void clearInjectors() {
        for (Injector injector : this.injectors.values()) {
            injector.clear();
        }
    }

    private String getPadding(long number) {
        String str = new Long(number).toString();
        return this.getPadding(str);
    }

    private String getPadding(String src) {
        String spaces = "                ";
        if (src == null) {
            return spaces;
        }
        return spaces.substring(src.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logAnalysisToFile() {
        Map allStats = CallAnalyse.getSummary();
        OutputStreamWriter writer = null;
        try {
            File f = new File("/tmp", "ibu-stats-" + System.currentTimeMillis());
            writer = new FileWriter(f, false);
            for (String name : allStats.keySet()) {
                CallAnalyse.CallStatistics stats = (CallAnalyse.CallStatistics)allStats.get(name);
                String str = stats.getAvgTime() + this.getPadding(stats.getAvgTime()) + stats;
                writer.write(str + "\n");
            }
        }
        catch (IOException ioe) {
            this.log.error((Object)"Error opening or writing file", (Throwable)ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    this.log.error((Object)"Error closing file", (Throwable)ioe);
                }
            }
        }
    }

    protected static enum InjectorsInstances {
        InjectorEvent{

            @Override
            public Injector getInstance() {
                return new InjectorEvent();
            }
        }
        ,
        InjectorLigneProduit{

            @Override
            public Injector getInstance() {
                return new InjectorLigneProduit();
            }
        }
        ,
        InjectorEleveur{

            @Override
            public Injector getInstance() {
                return new InjectorEleveur();
            }
        }
        ,
        InjectorChauffeur{

            @Override
            public Injector getInstance() {
                return new InjectorChauffeur();
            }
        }
        ,
        InjectorInfoChargement{

            @Override
            public Injector getInstance() {
                return new InjectorInfoChargement();
            }
        }
        ,
        InjectorTransporteur{

            @Override
            public Injector getInstance() {
                return new InjectorTransporteur();
            }
        }
        ,
        InjectorUsine{

            @Override
            public Injector getInstance() {
                return new InjectorUsine();
            }
        }
        ,
        InjectorEtape{

            @Override
            public Injector getInstance() {
                return new InjectorEtape();
            }
        }
        ,
        InjectorCommande{

            @Override
            public Injector getInstance() {
                return new InjectorCommande();
            }
        }
        ,
        InjectorTour{

            @Override
            public Injector getInstance() {
                return new InjectorTour();
            }
        }
        ,
        InjectorSociete{

            @Override
            public Injector getInstance() {
                return new InjectorSociete();
            }
        }
        ,
        InjectorCamion{

            @Override
            public Injector getInstance() {
                return new InjectorCamion();
            }
        }
        ,
        InjectorLabel{

            @Override
            public Injector getInstance() {
                return new InjectorLabel();
            }
        }
        ,
        InjectorAutorisation{

            @Override
            public Injector getInstance() {
                return new InjectorAutorisation();
            }
        }
        ,
        InjectorUser{

            @Override
            public Injector getInstance() {
                return new InjectorUser();
            }
        }
        ,
        InjectorEleveurGPS{

            @Override
            public Injector getInstance() {
                return new InjectorEleveurGPS();
            }
        }
        ,
        InjectorEleveurDuplicated{

            @Override
            public Injector getInstance() {
                return new InjectorEleveurDuplicated();
            }
        };


        public abstract Injector getInstance();
    }
}

