/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;

public class ModifsCollector {
    protected String key;
    protected List<Modif> modifs;

    public ModifsCollector() {
        this(null);
    }

    public ModifsCollector(String key) {
        this.key = key;
        this.modifs = Lists.newArrayList();
    }

    public void add(Class clazz, String property, Object oldValue, Object newValue) {
        this.modifs.add(new Modif(clazz, property, oldValue, newValue));
    }

    public void add(String text, boolean modif) {
        this.modifs.add(new Modif(text, modif));
    }

    public boolean isModified() {
        for (Modif modif : this.modifs) {
            if (!modif.isModified()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isModified()) {
            StringBuilder toStringBuilder = new StringBuilder(this.key + " : ");
            toStringBuilder.append(StringUtils.join(this.modifs, (String)", "));
            return toStringBuilder.toString();
        }
        return "";
    }

    protected class Modif {
        protected Class clazz;
        protected String property;
        protected Object oldValue;
        protected Object newValue;
        protected String text;
        protected boolean modif;

        public Modif(Class clazz, String property, Object oldValue, Object newValue) {
            this.clazz = clazz;
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Modif(String text, boolean modif) {
            this.text = text;
            this.modif = modif;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public String toString() {
            if (this.isModified()) {
                if (StringUtils.isNotEmpty((CharSequence)this.text)) {
                    return this.text;
                }
                String oldText = this.toString(this.getOldValue());
                String newText = this.toString(this.getNewValue());
                return this.getClazz().getSimpleName() + "#" + this.getProperty() + " oldValue[" + oldText + "] newValue[" + newText + "]";
            }
            return "";
        }

        public boolean isModified() {
            if (StringUtils.isNotEmpty((CharSequence)this.text)) {
                return this.modif;
            }
            if (this.getOldValue() == null) {
                return this.getNewValue() != null;
            }
            return !this.getOldValue().equals(this.getNewValue());
        }

        protected String toString(Object value) {
            String text = ObjectUtils.toString((Object)value);
            if (value != null && value instanceof TopiaEntity) {
                text = ((TopiaEntity)value).getTopiaId();
            }
            return text;
        }
    }
}

