package com.cybelia.sandra.ibu.manager;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.ibu.MigrationContext;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuAutorisation;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurDuplicated;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurGPS;
import com.cybelia.sandra.ibu.csv.bean.IbuEvent;
import com.cybelia.sandra.ibu.csv.bean.IbuLabel;
import com.cybelia.sandra.ibu.csv.bean.IbuTransporteur;
import com.cybelia.sandra.ibu.csv.bean.IbuUser;
import com.cybelia.sandra.ibu.csv.bean.IbuUsine;
import com.cybelia.sandra.ibu.injector.InjectorAutorisation;
import com.cybelia.sandra.ibu.injector.InjectorCamion;
import com.cybelia.sandra.ibu.injector.InjectorChauffeur;
import com.cybelia.sandra.ibu.injector.InjectorCommande;
import com.cybelia.sandra.ibu.injector.InjectorEleveur;
import com.cybelia.sandra.ibu.injector.InjectorEleveurDuplicated;
import com.cybelia.sandra.ibu.injector.InjectorEleveurGPS;
import com.cybelia.sandra.ibu.injector.InjectorEtape;
import com.cybelia.sandra.ibu.injector.InjectorEvent;
import com.cybelia.sandra.ibu.injector.InjectorInfoChargement;
import com.cybelia.sandra.ibu.injector.InjectorLabel;
import com.cybelia.sandra.ibu.injector.InjectorLigneProduit;
import com.cybelia.sandra.ibu.injector.InjectorSociete;
import com.cybelia.sandra.ibu.injector.InjectorTour;
import com.cybelia.sandra.ibu.injector.InjectorTransporteur;
import com.cybelia.sandra.ibu.injector.InjectorUser;
import com.cybelia.sandra.ibu.injector.InjectorUsine;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;
import org.nuiton.util.CallAnalyse;
import org.nuiton.util.CallAnalyse.CallStatistics;
import org.nuiton.util.CallAnalyse.CallStatisticsSummary;

public class ManagerInjector {

   private final Log log = LogFactory.getLog(ManagerInjector.class);

   protected TopiaContext rootContext;
   protected TopiaContext transaction;
   protected Map<String, Injector> injectors;

   protected List<Eleveur> createdEleveurs;

   protected enum InjectorsInstances {

       InjectorEvent {

           public Injector getInstance() {
               return new InjectorEvent();
           }
       },
       InjectorLigneProduit {

           public Injector getInstance() {
               return new InjectorLigneProduit();
           }
       },
       InjectorEleveur {

           public Injector getInstance() {
               return new InjectorEleveur();
           }
       },
       InjectorChauffeur {

           public Injector getInstance() {
               return new InjectorChauffeur();
           }
       },
       InjectorInfoChargement {

           public Injector getInstance() {
               return new InjectorInfoChargement();
           }
       },
       InjectorTransporteur {

           public Injector getInstance() {
               return new InjectorTransporteur();
           }
       },
       InjectorUsine {

           public Injector getInstance() {
               return new InjectorUsine();
           }
       },
       InjectorEtape {

           public Injector getInstance() {
               return new InjectorEtape();
           }
       },
       InjectorCommande {

           public Injector getInstance() {
               return new InjectorCommande();
           }
       },
       InjectorTour {

           public Injector getInstance() {
               return new InjectorTour();
           }
       },
       InjectorSociete {

           public Injector getInstance() {
               return new InjectorSociete();
           }
       },
       InjectorCamion {

           public Injector getInstance() {
               return new InjectorCamion();
           }
       },
       InjectorLabel {

           public Injector getInstance() {
               return new InjectorLabel();
           }
       },
       InjectorAutorisation {

           public Injector getInstance() {
               return new InjectorAutorisation();
           }
       },
       InjectorUser {

           public Injector getInstance() {
               return new InjectorUser();
           }
       },
       InjectorEleveurGPS {

           public Injector getInstance() {
               return new InjectorEleveurGPS();
           }
       },
       InjectorEleveurDuplicated {

           public Injector getInstance() {
               return new InjectorEleveurDuplicated();
           }
       };

       public abstract Injector getInstance();
   }

   public TopiaContext getTransaction() {
       return transaction;
   }

   public void setTransaction(TopiaContext transaction) {
       this.transaction = transaction;
   }

   public void setRootContext(TopiaContext rootContext) {
       this.rootContext = rootContext;
   }

   public TopiaContext getRootContext() throws IOException, TopiaNotFoundException {
       // Lazy
       if (rootContext == null) {
            rootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
       }
       return rootContext;
   }

   public ManagerInjector() {
       injectors = new java.util.TreeMap<String, Injector>();

       for (InjectorsInstances injector : InjectorsInstances.values()) {
           injectors.put(injector.name(), injector.getInstance());

           if (log.isTraceEnabled()) {
               log.trace("load [" + injector.name() + "]");
           }
       }
       createdEleveurs = Lists.newArrayList();
   }

   public void addCreatedEleveur(Eleveur createdEleveur) {
       createdEleveurs.add(createdEleveur);
   }

   @Override
   public void finalize() throws Throwable {
       super.finalize();
       try {
           if (!getRootContext().isClosed()) {
               // Fermeture de la connexion
//                rootContext.closeContext();
           }
       } catch (Exception e) {
           log.fatal("Injector error", e);
           throw new RuntimeException("Error closing connection", e);
       }
   }

   @SuppressWarnings({"unchecked"})
   public <T extends Injector> T getInjector(Class<T> klass) {
       return (T) injectors.get(klass.getSimpleName());
   }

   /**
    * Permet d'intégrer des fichiers CSV provenant de ibu dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param ibus             les donnees a injecter
    */
   public void injectIbus(MigrationContext contextMigration, List<Ibu> ibus) {
       try {
           // Check connection
           transaction = getRootContext().beginTransaction();
           transaction.rollbackTransaction();
       } catch (Exception e) {
           log.fatal("Injector error", e);
           throw new RuntimeException("Error opening connection", e);
       } finally {
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
       int lineNumber = 0;
       InjectorCommande injectorCommande = getInjector(InjectorCommande.class);
       InjectorSociete injectorSociete = getInjector(InjectorSociete.class);
       InjectorUsine injectorUsine = getInjector(InjectorUsine.class);
       InjectorCamion injectorCamion = getInjector(InjectorCamion.class);
       InjectorInfoChargement injectorInfoChargement = getInjector(InjectorInfoChargement.class);
       InjectorChauffeur injectorChauffeur = getInjector(InjectorChauffeur.class);
       InjectorTransporteur injectorTransporteur = getInjector(InjectorTransporteur.class);
       InjectorEleveur injectorEleveur = getInjector(InjectorEleveur.class);
       InjectorTour injectorTour = getInjector(InjectorTour.class);
       InjectorEtape injectorEtape = getInjector(InjectorEtape.class);
       InjectorLigneProduit injectorLigneProduit = getInjector(InjectorLigneProduit.class);

       try {
           if (log.isTraceEnabled()) {
               log.trace("Begin transaction...");
           }
           transaction = getRootContext().beginTransaction();
           for (Ibu ibu : ibus) {
               lineNumber++;

               if (ibu != null) {
                   String step = "init";

                   try {
                       clearInjectors();

                       if (log.isTraceEnabled()) {
                           log.trace(ibu);
                       }
                       
                       log.info("Commande [" + ibu.getCommandeCode() + "] camion [" + ibu.getCamionCodeSociete() + "] tour [" + ibu.getTourNumero() + "] date [" + ibu.getTourDateLivraison() + "]");

                       step = "injectorCommande";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject commande ...");
                       }
                       injectorCommande.inject(this, ibu);

                       step = "injectorSociete";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject societe...");
                       }
                       injectorSociete.inject(this, ibu);

                       step = "injectorUsine";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject usine...");
                       }
                       injectorUsine.inject(this, ibu);

                       step = "injectorEleveur";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject eleveur...");
                       }
                       injectorEleveur.inject(this, ibu);

                       step = "injectorLigneProduit";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject ligne produit...");
                       }
                       injectorLigneProduit.inject(this, ibu);

                       step = "injectorCamion";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject camion...");
                       }
                       injectorCamion.inject(this, ibu);

                       step = "injectorChauffeur";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject chauffeur...");
                       }
                       injectorChauffeur.inject(this, ibu);

                       step = "injectorTransporteur";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject transporteur...");
                       }
                       injectorTransporteur.inject(this, ibu);

                       step = "injectorTour";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject tour...");
                       }
                       injectorTour.inject(this, ibu);

                       step = "injectorEtape";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject etape...");
                       }
                       injectorEtape.inject(this, ibu);

                       step = "injectorInfoChargement";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject info chargement...");
                       }
                       injectorInfoChargement.inject(this, ibu);

                       step = "injectCamionUser";
                       if (log.isTraceEnabled()) {
                           log.trace("Inject camion user...");
                       }

                       injectCamionUser(contextMigration);
                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectIbus error. Step is: " + step, eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                       throw eee;
                   }  finally {
                       try {

                           if (log.isTraceEnabled()) {
                               log.trace("Commit transaction...");
                           }
                           transaction.commitTransaction();

//                           ((TopiaContextImpl)transaction).getHibernate().flush();

                           // check if breeders created are duplicated
                           SandraHelper.checkDuplicateBreeder(transaction, createdEleveurs, "ibuEleveurCreation");

                           // clear created breeders
                           createdEleveurs.clear();

                       } catch (TopiaException ex) {
                           log.error("Cant commit transaction", ex);
                       }
                   }
               }
           }
       } catch (Exception eee) {
           if (log.isErrorEnabled()) {
               log.error("injectIbus error", eee);
           }
           contextMigration.addErrorMsg(eee.getMessage());
           contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
           if (transaction != null) {
               try {
                    if (!transaction.isClosed()) {
                       transaction.rollbackTransaction();
                       transaction.closeContext();
                    }
               } catch (TopiaException te) {
                   log.error("Error during Rollback. Data may not be integrated correctly", te);
               }
           }
       }  finally {
           try {

               Date now = new Date();

               if (!transaction.isClosed()) {
                   transaction.closeContext();
               }
               Date after = new Date();
               if (log.isDebugEnabled()) {
                   log.debug("Time between log and close context : " + getDifferenceInMilliSeconds(now, after) + "ms");
               }

           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
       }
   }

    public static int getDifferenceInMilliSeconds(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int) Math.ceil(end - begin);
    }


   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les usines dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param usines           les donnees a injecter
    */
   public void injectUsines(MigrationContext contextMigration, List<IbuUsine> usines) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorUsine injectorUsine = getInjector(InjectorUsine.class);

           int lineNumber = 0;
           for (IbuUsine usine : usines) {
               lineNumber++;
               if (usine != null) {
                   try {
                       log.info(usine);

                       log.info("Inject usine ...");
                       injectorUsine.inject(this, usine);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectUsines error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les camions dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param camions          les donnees a injecter
    */
   public void injectCamions(MigrationContext contextMigration, List<IbuCamion> camions) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorSociete injectorSociete = getInjector(InjectorSociete.class);
           InjectorCamion injectorCamion = getInjector(InjectorCamion.class);
           InjectorTransporteur injectorTransporteur = getInjector(InjectorTransporteur.class);

           int lineNumber = 0;
           for (IbuCamion camion : camions) {
               lineNumber++;
               if (camion != null) {
                   try {
                       log.info(camion);

                       log.info("Inject societe ...");
                       injectorSociete.inject(this, camion);

                       log.info("Inject transporteur ...");
                       injectorTransporteur.inject(this, camion);

                       log.info("Inject camion ...");
                       injectorCamion.inject(this, camion);

                       log.info("Inject camion user ...");
                       injectCamionUser(contextMigration);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectCamions error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les chauffeurs dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param chauffeurs       les donnees a injecter
    */
   public void injectChauffeurs(MigrationContext contextMigration, List<IbuChauffeur> chauffeurs) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorSociete injectorSociete = getInjector(InjectorSociete.class);
           InjectorChauffeur injectorChauffeur = getInjector(InjectorChauffeur.class);

           int lineNumber = 0;
           for (IbuChauffeur chauffeur : chauffeurs) {
               lineNumber++;
               if (chauffeur != null) {
                   try {
                       log.info(chauffeur);

                       log.info("Inject societe ...");
                       injectorSociete.inject(this, chauffeur);

                       log.info("Inject chauffeur ...");
                       injectorChauffeur.inject(this, chauffeur);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectChauffeurs error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les transporteurs dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param transporteurs    les donnees a injecter
    */
   public void injectTransporteurs(MigrationContext contextMigration, List<IbuTransporteur> transporteurs) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorSociete injectorSociete = getInjector(InjectorSociete.class);
           InjectorTransporteur injectorTransporteur = getInjector(InjectorTransporteur.class);

           int lineNumber = 0;
           for (IbuTransporteur transporteur : transporteurs) {
               lineNumber++;
               if (transporteur != null) {
                   try {
                       log.info(transporteur);

                       log.info("Inject societe ...");
                       injectorSociete.inject(this, transporteur);

                       log.info("Inject transporteur ...");
                       injectorTransporteur.inject(this, transporteur);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectTransporteurs error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les autorisations dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param data             les donnees a injecter
    */
   public void injectAutorisations(MigrationContext contextMigration, List<IbuAutorisation> data) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorAutorisation injector = getInjector(InjectorAutorisation.class);

           int lineNumber = 0;
           for (IbuAutorisation event : data) {
               lineNumber++;
               if (event != null) {
                   try {
                       log.info(event);

                       log.info("Inject autorisation ...");
                       injector.inject(this, event);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectAutorisations error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les utilisateurs dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param data             les donnees a injecter
    */
   public void injectUsers(MigrationContext contextMigration, List<IbuUser> data) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorUser injector = getInjector(InjectorUser.class);

           int lineNumber = 0;
           for (IbuUser event : data) {
               lineNumber++;
               if (event != null) {
                   try {
                       log.info(event);

                       log.info("Inject user ...");
                       injector.inject(this, event);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectUsers error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Inject les utilisateurs de type camion
    *
    * @param contextMigration le contexte de ibu
    */
   public void injectCamionUsers(MigrationContext contextMigration) {
       try {
           transaction = getRootContext().beginTransaction();
           CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(transaction);

           List<Camion> camions = camionDAO.findAll();
           for (Camion camion : camions) {
               injectCamionUser(camion);
               log.info("Inject user " + camion.getSociete().getCode() + "-" + camion.getCode() + " ... success");
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Inject un utilisateur de type camion
    *
    * @param camion les donnees a injecter
    * @throws TopiaException if any database pb
    */
   public void injectCamionUser(Camion camion) throws TopiaException {
       String login = camion.getSociete().getCode() + "-" + camion.getCode();
       String password = login;

       // DAOs
       TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(getTransaction());
       TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(getTransaction());

       if (userDAO.findByLogin(login) == null && principalDAO.findByName(login) == null) {
           // Users
           TaasUser user = userDAO.create();
           user.setLogin(login);
           user.setPassword(TaasUtil.hash(password));
           user.setEnabled(true);
           user.setLink(camion.getSociete().getTopiaId());

           log.info("Inject user ... success");

           SandraHelper.createUserIndicateurIfDontExist(getTransaction(), user);

           // Principals
           TaasPrincipal principal = principalDAO.create();
           principal.setName(login);
           user.addPrincipals(principal);

           TaasPrincipal principalUser = principalDAO.findByName("synchro");
           user.addPrincipals(principalUser);

           log.info("Inject principal ... success");
       }
   }

   /**
    * Inject un utilisateur de type camion depuis le context de ibu
    *
    * @param contextMigration le contexte de ibu
    * @throws TopiaException if any database pb
    */
   public void injectCamionUser(MigrationContext contextMigration) throws TopiaException {
       // Récupération des informations
       Camion camion = getCamion();
       injectCamionUser(camion);
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les usines dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param labels           les donnees a injecter
    */
   public void injectLabels(MigrationContext contextMigration, List<IbuLabel> labels) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorLabel injector = getInjector(InjectorLabel.class);

           int lineNumber = 0;
           for (IbuLabel label : labels) {
               lineNumber++;
               if (label != null) {
                   try {
                       log.info(label);

                       log.info("Inject label ...");
                       injector.inject(this, label);

                   } catch (Exception eee) {
                       if (log.isErrorEnabled()) {
                           log.error("injectLabel error", eee);
                       }
                       contextMigration.addErrorMsg(eee.getMessage());
                       contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les evenements dans la base de données Sandra
    *
    * @param contextMigration le contexte de ibu
    * @param events           les donnees a injecter
    */
   public void injectEvents(MigrationContext contextMigration, List<IbuEvent> events) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorEvent injector = getInjector(InjectorEvent.class);

           int lineNumber = 0;
           for (IbuEvent event : events) {
               lineNumber++;
               try {
                   log.info(event);

                   log.info("Inject event ...");
                   injector.inject(this, event);

               } catch (Exception eee) {
                   if (log.isErrorEnabled()) {
                       log.error("injectEvent error", eee);
                   }
                   contextMigration.addErrorMsg(eee.getMessage());
                   contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les coordonnees eleveurs
    *
    * @param contextMigration le contexte de ibu
    * @param eleveurGPSs           les donnees a injecter
    */
   public void injectEleveurGPS(MigrationContext contextMigration, List<IbuEleveurGPS> eleveurGPSs) {
       try {
           transaction = getRootContext().beginTransaction();
           InjectorEleveurGPS injector = getInjector(InjectorEleveurGPS.class);

           int lineNumber = 0;
           log.info("Inject eleveurGPS ...");
           for (IbuEleveurGPS eleveurGPS : eleveurGPSs) {
               lineNumber++;
               try {
                   log.info(eleveurGPS);

                   injector.inject(this, eleveurGPS);
                   injector.clear();
               } catch (Exception eee) {
                   if (log.isErrorEnabled()) {
                       log.error("injectEvent error", eee);
                   }
                   contextMigration.addErrorMsg(eee.getMessage());
                   contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       } finally {
           try {
               transaction.commitTransaction();
           } catch (TopiaException ex) {
               log.error("Cant commit transaction", ex);
           }
           try {
               transaction.closeContext();
           } catch (TopiaException ex) {
               log.error("Cant close context", ex);
           }
       }
   }

   /**
    * Permet d'intégrer des fichiers CVS contenant les données sur les coordonnees eleveurs
    *
    * @param contextMigration le contexte de ibu
    * @param eleveurDuplicateds           les donnees a injecter
    */
   public void injectEleveurDuplicated(MigrationContext contextMigration, List<IbuEleveurDuplicated> eleveurDuplicateds) {
       try {
           int lineNumber = 0;
           log.info("Inject eleveurDuplicated ...");
           for (IbuEleveurDuplicated eleveurDuplicated : eleveurDuplicateds) {
               lineNumber++;
               try {
                   log.info(eleveurDuplicated);

                   transaction = getRootContext().beginTransaction();
                   InjectorEleveurDuplicated injector = getInjector(InjectorEleveurDuplicated.class);

                   injector.inject(this, eleveurDuplicated);
                   injector.clear();

               } catch (Exception eee) {
                   if (log.isErrorEnabled()) {
                       log.error("injectEvent error", eee);
                   }
                   contextMigration.addErrorMsg(eee.getMessage());
                   contextMigration.getInjectorErrorLineNumbers().add(lineNumber);
               }  finally {
                   try {

                       transaction.commitTransaction();
                   } catch (TopiaException ex) {
                       log.error("Cant commit transaction", ex);
                   }
                   try {
                       transaction.closeContext();
                   } catch (TopiaException ex) {
                       log.error("Cant close context", ex);
                   }
               }
           }

       } catch (Exception e) {
//          transaction.rollbackTransaction();
//          transaction.closeContext();
           log.error("Injector error", e);
           throw new RuntimeException(e);
       }
   }

   public Usine getUsine() {
       return getInjector(InjectorUsine.class).getObject();
   }

   public Tour getTour() {
       return getInjector(InjectorTour.class).getObject();
   }

   public Camion getCamion() {
       return getInjector(InjectorCamion.class).getObject();
   }

   public Chauffeur getChauffeur() {
       return getInjector(InjectorChauffeur.class).getObject();
   }

   public Commande getCommande() {
       return getInjector(InjectorCommande.class).getObject();
   }

   public LigneProduit getLigneProduit() {
       return getInjector(InjectorLigneProduit.class).getObject();
   }

   public Eleveur getEleveur() {
       return getInjector(InjectorEleveur.class).getObject();
   }

   public InfoAccess getSilo() {
       return getInjector(InjectorEleveur.class).getSilo();
   }

   public Etape getEtape() {
       return getInjector(InjectorEtape.class).getObject();
   }

   public InfoChargement getInfoChargement() {
       return getInjector(InjectorInfoChargement.class).getObject();
   }

   public Societe getSociete() {
       return getInjector(InjectorSociete.class).getObject();
   }

   public Transporteur getTransporteur() {
       return getInjector(InjectorTransporteur.class).getObject();
   }

   public Label getLabel() {
       return getInjector(InjectorLabel.class).getObject();
   }

    public boolean isInfoChargementChanged() {
        return getInjector(InjectorInfoChargement.class).isInfoChargementChanged();
    }

    public boolean isCommandeCreated() {
        return getInjector(InjectorCommande.class).isCommandeCreated();
    }

   /**
    * Réinitialise les injecteurs
    */
   public void clearInjectors() {
       for (Injector injector : injectors.values()) {
           injector.clear();
       }
   }

   private String getPadding(long number) {
       String str = (new Long(number)).toString();
       return getPadding(str);
   }

   private String getPadding(String src) {
       String spaces = "                ";
       if (src == null) {
           return spaces;
       }
       return spaces.substring(src.length());
   }

   /**
    * Ecrit les stats dans un fichier dans /tmp
    */
   protected void logAnalysisToFile() {
       Map<String, CallStatisticsSummary> allStats = CallAnalyse.getSummary();
       FileWriter writer = null;
       try {
           File f = new File("/tmp", "ibu-stats-" + System.currentTimeMillis());
           writer = new FileWriter(f, false);
           for (String name : allStats.keySet()) {
               CallStatistics stats = allStats.get(name);
               String str = stats.getAvgTime() + getPadding(stats.getAvgTime()) + stats;
               writer.write(str + "\n");
           }
       } catch (IOException ioe) {
           log.error("Error opening or writing file", ioe);
       } finally {
           if (writer != null) {
               try {
                   writer.close();
               } catch (IOException ioe) {
                   log.error("Error closing file", ioe);
               }
           }
       }

   }
} //ManagerInjector