package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuUser;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

public class InjectorUser implements Injector {

    protected TaasUser data;

    public TaasUser getObject() {
        return data;
    }

    public void clear() {
        data = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        //nothing to do ?    
    }

    public void inject(ManagerInjector manager, IbuUser user) throws TopiaException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(manager.getTransaction());
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(manager.getTransaction());

        // Recherche
        data = userDAO.findByLogin(user.getName());

        // Création
        if (data == null) {
            data = userDAO.create();
            data.setLogin(user.getName());
            data.setEnabled(true);
            data.setPrincipals(new ArrayList<TaasPrincipal>());

            SandraHelper.createUserIndicateurIfDontExist(manager.getTransaction(), data);
        }

        // Mise à jour
        data.setEmail(user.getEmail());
        data.setPassword(TaasUtil.hash(user.getPasswd()));

        // Principal
        TaasPrincipal principal = principalDAO.findByName(user.getPrincipal());
        if (principal == null) {
            throw new UnsupportedOperationException("Principal inconnu "
                    + user.getPrincipal());
        }

        if (!data.getPrincipals().contains(principal)) {
            data.addPrincipals(principal);
        }
    }
}
