package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.ibu.ModifsCollector;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorTour implements Injector {

    private final org.apache.commons.logging.Log log = LogFactory.getLog(InjectorTour.class);

    protected Tour tour;
    protected boolean commandeCommentaireIsModif = false;
    protected boolean commandeActifIsModif = false;

    public Tour getObject() {
        return tour;
    }

    public void clear() {
        tour = null;
        commandeCommentaireIsModif = false;
        commandeActifIsModif = false;
    }

    public void setCommandeCommentaireIsModif(boolean commandeCommentaireIsModif) {
        this.commandeCommentaireIsModif = commandeCommentaireIsModif;
    }

    public void setCommandeActifChange(boolean commandeActifIsModif) {
        this.commandeActifIsModif = commandeActifIsModif;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        TourDAO tourDAO = SandraDAOHelper.getTourDAO(manager.getTransaction());

        Camion camion = manager.getCamion();

        tour = tourDAO.findByNaturalId(ibu.getTourDateLivraison(),
                ibu.getTourNumero(),
                camion);

        // Création
        if (tour == null) {
            tour = tourDAO.createByNaturalId(ibu.getTourDateLivraison(),
                    ibu.getTourNumero(),
                    camion);

            SynchNumberManager.notifyTourCreated(manager,
                    tour,
                    camion.getTopiaId(),
                    "[IBU] creation du tour");

            String msg = SandraHelper.getLogTour(tour, "create tour");
            log.info(msg);

        } else {
            LigneProduit ligneProduit = manager.getLigneProduit();

            ModifsCollector modifsCollectorImpactSuivi = new ModifsCollector("[IBU] tour change because impact suiviTour : ");
            modifsCollectorImpactSuivi.add(Tour.class, Tour.PROPERTY_DATE_LIVRAISON, tour.getDateLivraison().getTime(), ibu.getTourDateLivraison().getTime());
            modifsCollectorImpactSuivi.add(Tour.class, Tour.PROPERTY_NUMERO, tour.getNumero(), ibu.getTourNumero());
            modifsCollectorImpactSuivi.add("Commande created", manager.isCommandeCreated());
            modifsCollectorImpactSuivi.add("Commande actif changed", commandeActifIsModif);
            modifsCollectorImpactSuivi.add("Infochargement changed", manager.isInfoChargementChanged());

            ModifsCollector modifsCollector = new ModifsCollector("[IBU] tour change because : ");
            modifsCollector.add(Tour.class, Tour.PROPERTY_COMMENTAIRE, tour.getCommentaire(), ibu.getTourCommentaire());
            modifsCollector.add(Tour.class, Tour.PROPERTY_DEFAUT_CHAUFFEUR, tour.getDefautChauffeur(), manager.getChauffeur());

            // TMA 157 : Une modification de code silo n'est pas pris en compte sur les boitiers
            // (https://jira.groupe-glon.fr/jira/browse/SDRAMTNC-157)
            modifsCollector.add(LigneProduit.class, LigneProduit.PROPERTY_SILO,
                    ligneProduit.getSilo(),
                    manager.getSilo());

            modifsCollector.add(LigneProduit.class, LigneProduit.PROPERTY_QUANTITE_ACHARGER, ligneProduit.getQuantiteACharger(), ibu.getProduitQuantiteAChargee());
            modifsCollector.add(LigneProduit.class, LigneProduit.PROPERTY_QUANTITE_COMMANDEE, ligneProduit.getQuantiteCommandee(), ibu.getProduitQuantiteCommandee());
            modifsCollector.add(LigneProduit.class, LigneProduit.PROPERTY_CODE, ligneProduit.getCode(), ibu.getProduitCode());
            modifsCollector.add("comande commentaire modifie", commandeCommentaireIsModif);

            Etape oldEtape = ligneProduit.getEtape();
            if (oldEtape != null) {
                Tour oldTour = oldEtape.getTour();
                Camion oldCamion = oldTour.getCamion();
                String oldCamionSocieteCode = oldCamion.getSociete().getCode() + "-" + oldCamion.getCode();
                modifsCollectorImpactSuivi.add(Tour.class, Tour.TOPIA_ID, oldTour.getTopiaId(), tour.getTopiaId());
                modifsCollectorImpactSuivi.add(Societe.class, Societe.PROPERTY_CODE, oldCamionSocieteCode, ibu.getCamionCodeSociete());
            }

            // Modification
            if (modifsCollector.isModified() || modifsCollectorImpactSuivi.isModified()){

                if (modifsCollectorImpactSuivi.isModified()) {

                    // Suppression des suivis
                    //suivi of manager.getTour() is deleted above (before if/else)
                    deleteSuiviTour(log, manager, tour);

                    if (oldEtape != null) {
                        Tour oldTour = oldEtape.getTour();
                        deleteSuiviTour(log, manager, oldTour);

                        SynchNumberManager.notifyTourChange(manager,
                                oldTour,
                                oldTour.getCamion().getTopiaId(),
                                "lancien tour a change");

                        String msg = SandraHelper.getLogTour(oldTour, "old tour");
                        log.info(msg);
                    }
                }

                SynchNumberManager.notifyTourChange(manager,
                        tour,
                        camion.getTopiaId(),
                        modifsCollector.toString() + " - " + modifsCollectorImpactSuivi.toString());
            }
            String msg = SandraHelper.getLogTour(tour, "");
            log.info(msg);
        }
        tour.setCommentaire(ibu.getTourCommentaire());
        tour.setDefautChauffeur(manager.getChauffeur());
        tour.setDateChargement(ibu.getTourChargement());
    }

    /**
     * Suppression des suivis d'une tournée, c'est à dire du SuiviTour, CRTour,
     * SuiviEtape, CREtape, SuiviUsine, SuiviLigneProduit, et CRUsine
     *
     * @param log logger
     * @param manager manager injector
     * @param tour tour sur laquelle supprimer les suivis
     * @throws TopiaException if exception occured
     */
    public static void deleteSuiviTour(org.apache.commons.logging.Log log, ManagerInjector manager, Tour tour) throws TopiaException {
        SuiviTour suiviTour = tour.getSuiviTour();
        Camion camion = tour.getCamion();
        if (log.isDebugEnabled()) {
            log.debug("Suppression des suivis pour le tour n°" + tour.getNumero() +
                    " pour une date de livraison le " + tour.getDateLivraison() +
                    " pour le camion " + camion.getSociete().getCode() +
                    "-" + camion.getCode() + " : " + tour.getTopiaId());
        }
        if (suiviTour != null) {

            TopiaContext transaction = manager.getTransaction();
            SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO(transaction);
            suiviTourDAO.delete(suiviTour);
        }
    }

}