package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorEleveur implements Injector {

    protected static final Log log = LogFactory.getLog(InjectorEleveur.class);

    protected static final String SILO_PREFIX = "S";

    protected Eleveur eleveur;
    protected InfoAccess silo;

    public Eleveur getObject() {
        return eleveur;
    }

    public InfoAccess getSilo() {
        return silo;
    }

    public void clear() {
        eleveur = null;
        silo = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(manager.getTransaction());
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(manager.getTransaction());

        // search on naturalIds
        eleveur = eleveurDAO.findByNaturalId(manager.getSociete(), ibu.getEleveurCode());

        // create new one if not found
        if (eleveur == null) {
            eleveur = eleveurDAO.createByNaturalId(manager.getSociete(), ibu.getEleveurCode());

            // Creation de l'acces eleveur
            InfoAccess infoAccess = infoAccessDAO.create();
            infoAccess.setNiveauSecurite(-1);
            infoAccess.setEtat(0);
            infoAccessDAO.update(infoAccess);
            eleveur.setAccesEleveur(infoAccess);

            // https://jira.groupe-glon.fr/browse/SDRAMTNC-295
            // set raisonSocial, adresse and ville only on creation and on web
            eleveur.setRaisonSociale(ibu.getEleveurRaisonSociale());
            eleveur.setAdresse(ibu.getEleveurAdresse() + " " + ibu.getEleveurVille());
            eleveur.setCodePostal(ibu.getEleveurCodePostal());
            eleveur.setVille(ibu.getEleveurCommune());
            eleveur.setCodeINSEE(ibu.getEleveurCommuneCode());

            // keep eleveur for check doublons
            manager.addCreatedEleveur(eleveur);

            log.info("Eleveur '" + eleveur.getSociete().getCode() + "-" + eleveur.getCode() + "' created");
        }

        if (ibu.getProduitCapaciteUnitaire() != null && ibu.getProduitCapaciteUnitaire().equals("00")) {
            // Acces silo
            String siloNom = ibu.getProduitSilo();

            // Si il est nommee dans ibu
            if (StringUtils.isNotBlank(siloNom) && !siloNom.trim().equals("0")) {

                // Initialisation de la list des silos
                if (eleveur.getAccesSilos() == null) {
                    List<InfoAccess> silos = new ArrayList<InfoAccess>();
                    eleveur.setAccesSilos(silos);
                }

                // TMA 193 : Replace numeric names by S#
                try {

                    // Verify if numeric
                    int siloNum = Integer.parseInt(siloNom);

                    // If no exception, add prefix on name
                    String newSiloNom = SILO_PREFIX + siloNum;

                    // Try to find existing with old name
                    silo = getIfExist(eleveur, siloNom);
                    if (silo != null) {

                        InfoAccess newSilo = getIfExist(eleveur, newSiloNom);
                        if (newSilo != null) {
                            // Delete non numeric if both exist
                            infoAccessDAO.delete(silo);

                            // Use found
                            silo = newSilo;
                        } else {
                            // If found, replace oldName by new one
                            silo.setNomAcces(newSiloNom);
                            silo = infoAccessDAO.update(silo);
                        }
                    }

                    if (log.isDebugEnabled()) {
                        log.debug("Replace numerical name '" + siloNom + "' by '" + newSiloNom + "'");
                    }

                    siloNom = newSiloNom;

                } catch (NumberFormatException eee) {
                    // Do nothing in this case
                }

                // Dont repeate operation if silo with old name is found
                if (silo == null) {

                    // Search existing
                    silo = getIfExist(eleveur, siloNom);
                    if (silo == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Creating acces silo : " + siloNom + " for eleveur : " + eleveur.getTopiaId());
                        }

                        // Creating new one
                        silo = infoAccessDAO.create();
                        silo.setNomAcces(siloNom);
                        silo.setEtat(InfoAccessEtat.INFOACCESS_ACTIF);
                        silo.setNiveauSecurite(-1);
                        silo.setType(0);

                        silo = infoAccessDAO.update(silo);
                        eleveur.addAccesSilos(silo);
                    }
                }
            }
        }

        // Mise à jour
        // https://jira.groupe-glon.fr/browse/SDRAMTNC-295
        // set raisonSocial, adresse and ville only on creation and on web
//        eleveur.setRaisonSociale(ibu.getEleveurRaisonSociale());
//        eleveur.setAdresse(ibu.getEleveurAdresse() + " " + ibu.getEleveurVille());
//        eleveur.setCodePostal(ibu.getEleveurCodePostal());
//        eleveur.setVille(ibu.getEleveurCommune());
//        eleveur.setCodeINSEE(ibu.getEleveurCommuneCode());

        eleveur.setTelephone(ibu.getEleveurTelephone());
        eleveur.setMobile(ibu.getEleveurMobile());
//        eleveur.getAccesEleveur().setNiveauSecurite(ibu.getEleveurSecurite());
        eleveur.setEmail(ibu.getEleveurMail());
        eleveur = eleveurDAO.update(eleveur);
    }

    protected boolean exist(Eleveur eleveur, String siloNom) {
        return getIfExist(eleveur, siloNom) != null;
    }

    protected InfoAccess getIfExist(Eleveur eleveur, String siloNom) {

        // Si il n'est pas deja cree
        for (InfoAccess s : eleveur.getAccesSilos()) {
            if (s != null) {
                if (siloNom.trim().equalsIgnoreCase(s.getNomAcces())) {
                    return s;
                }
            }
        }
        return null;
    }
}
