package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.CommandeDAO;
import com.cybelia.sandra.ibu.ModifsCollector;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorCommande implements Injector {

    private final org.apache.commons.logging.Log log = LogFactory.getLog(InjectorCommande.class);

    protected Commande commande;
    protected boolean commandeCreated = false;

    public Commande getObject() {
        return commande;
    }

    public boolean isCommandeCreated() {
        return commandeCreated;
    }

    public void clear() {
        commande = null;
        commandeCreated = false;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        CommandeDAO commandeDAO = SandraDAOHelper.getCommandeDAO(manager.getTransaction());

        // Recherche
        String commandeCode = ibu.getCommandeCode();
        commande = commandeDAO.findByNaturalId(commandeCode);

        // Création
        if (commande == null) {
            commande = commandeDAO.createByNaturalId(commandeCode);

            // Flag as created (https://jira.groupe-glon.fr/browse/SDRAMTNC-268)
            commandeCreated = true;
        }

        // Mofification du num de synchro si le commentaire de la commande à changer
        // TMA 157 : Une modification de code silo n'est pas pris en compte sur les boitiers
        // (https://jira.groupe-glon.fr/jira/browse/SDRAMTNC-157)
        ModifsCollector modifsCollector = new ModifsCollector();
        modifsCollector.add(Commande.class, Commande.PROPERTY_COMMENTAIRE, commande.getCommentaire(), ibu.getCommandeCommentaire());
        if  (modifsCollector.isModified()) {

             manager.getInjector(InjectorTour.class).setCommandeCommentaireIsModif(true);
        }

        // If camion is GUI, if commande existe -> GUI
        // Else or if it's already on GUI, skip
        boolean wasActif = commande.isActif();
        if ("GUI".equals(ibu.getCamionCode())) {
            commande.setActif(false);
        } else {
            commande.setActif(true);
        }

        ModifsCollector modifsActifCollector = new ModifsCollector();
        modifsActifCollector.add(Commande.class, Commande.PROPERTY_ACTIF, wasActif, commande.isActif());
        if  (modifsActifCollector.isModified()) {
            manager.getInjector(InjectorTour.class).setCommandeActifChange(true);
        }

        // Mise à jour
        commande.setCommentaire(ibu.getCommandeCommentaire());
        commande.setContrainteHoraire(ibu.getCommandeMoment());
    }
}
