package com.cybelia.sandra.ibu;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class ModifsCollector {
    
    protected String key;
    protected List<Modif> modifs;

    public ModifsCollector() {
        this(null);
    }

    public ModifsCollector(String key) {
        this.key = key;
        this.modifs = Lists.newArrayList();
    }
                                                                      
    public void add(Class clazz, String property, Object oldValue, Object newValue) {
        modifs.add(new Modif(clazz, property, oldValue, newValue));
    }

    public void add(String text, boolean modif) {
        modifs.add(new Modif(text, modif));
    }

    public boolean isModified() {
        for (Modif modif : modifs) {
            if (modif.isModified()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {

        if (isModified()) {
            // build comment
            StringBuilder toStringBuilder = new StringBuilder(key + " : ");

            toStringBuilder.append(StringUtils.join(modifs, ", "));

            return toStringBuilder.toString();
        }
        return StringUtils.EMPTY;
    }

    protected class Modif {

        protected Class clazz;
        protected String property;
        protected Object oldValue;
        protected Object newValue;
        protected String text;
        protected boolean modif;

        public Modif(Class clazz, String property, Object oldValue, Object newValue) {
            this.clazz = clazz;
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Modif(String text, boolean modif) {
            this.text = text;
            this.modif = modif;
        }

        public Class getClazz() {
            return clazz;
        }

        public String getProperty() {
            return property;
        }
    
        public Object getOldValue() {
            return oldValue;
        }
    
        public Object getNewValue() {
            return newValue;
        }
    
        @Override
        public String toString() {
            if (isModified()) {
                if (StringUtils.isNotEmpty(text)) {
                    return text;
                }

                String oldText = toString(getOldValue());
                String newText = toString(getNewValue());
                return getClazz().getSimpleName() + "#" + getProperty()+ " oldValue[" + oldText + "] newValue[" + newText + "]";
            }
            return StringUtils.EMPTY;
        }

        public boolean isModified() {
            if (StringUtils.isNotEmpty(text)) {
                return modif;
            }
            if (getOldValue() == null) {
                return !(getNewValue() == null);
            }
            return !getOldValue().equals(getNewValue());
        }

        protected String toString(Object value) {
            String text = ObjectUtils.toString(value);
            if (value != null && value instanceof TopiaEntity) {
                text = ((TopiaEntity)value).getTopiaId();
            }
            return text;
        }
    }
}
