/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.util.ArrayList;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import org.hibernatespatial.GeometryUserType;

public class TypeMapper {
    private static final String GEOMETRY_USER_TYPE = GeometryUserType.class.getCanonicalName();
    private List<TMEntry> entries = new ArrayList<TMEntry>();
    private String dbGeomType = "";
    private CtClass ctGeom;

    public TypeMapper(String dbGeomType) {
        this.dbGeomType = dbGeomType;
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
        CtClass ctString = null;
        CtClass ctDate = null;
        try {
            ctString = pool.get("java.lang.String");
            ctDate = pool.get("java.util.Date");
            this.ctGeom = pool.get("com.vividsolutions.jts.geom.Geometry");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.entries.add(new TMEntry(-5, "integer", CtClass.longType));
        this.entries.add(new TMEntry(5, "integer", CtClass.intType));
        this.entries.add(new TMEntry(16, "boolean", CtClass.booleanType));
        this.entries.add(new TMEntry(1, "string", ctString));
        this.entries.add(new TMEntry(91, "date", ctDate));
        this.entries.add(new TMEntry(3, "double", CtClass.doubleType));
        this.entries.add(new TMEntry(8, "double", CtClass.doubleType));
        this.entries.add(new TMEntry(2, "double", CtClass.doubleType));
        this.entries.add(new TMEntry(6, "double", CtClass.doubleType));
        this.entries.add(new TMEntry(4, "long", CtClass.longType));
        this.entries.add(new TMEntry(12, "string", ctString));
    }

    public CtClass getCtClass(String dbType, int sqlType) {
        if (dbType.equalsIgnoreCase(this.dbGeomType)) {
            return this.ctGeom;
        }
        for (TMEntry entry : this.entries) {
            if (entry.javaType != sqlType) continue;
            return entry.ctClass;
        }
        return null;
    }

    public String getHibernateType(String dbType, int sqlType) {
        if (dbType.equalsIgnoreCase(this.dbGeomType)) {
            return GEOMETRY_USER_TYPE;
        }
        for (TMEntry entry : this.entries) {
            if (entry.javaType != sqlType) continue;
            return entry.hibernateTypeName;
        }
        return null;
    }

    public int[] getMappedSQLTypes() {
        int l = this.entries.size();
        int[] types = new int[l];
        for (int i = 0; i < this.entries.size(); ++i) {
            types[i] = this.entries.get((int)i).javaType;
        }
        return types;
    }

    public void addTypeMapping(int sqlType, String hibernateType, CtClass ctClass) {
        this.entries.add(new TMEntry(sqlType, hibernateType, ctClass));
    }

    public void removeTypeMapping(int sqlType) {
        TMEntry tm = null;
        for (TMEntry t : this.entries) {
            if (t.javaType != sqlType) continue;
            tm = t;
            break;
        }
        if (tm != null) {
            this.entries.remove(tm);
        }
    }

    private static class TMEntry {
        protected int javaType = 0;
        protected String hibernateTypeName = "";
        protected CtClass ctClass;

        protected TMEntry(int jt, String ht, CtClass jc) {
            this.javaType = jt;
            this.hibernateTypeName = ht;
            this.ctClass = jc;
        }
    }
}

