/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.NamingStrategy;
import org.hibernatespatial.pojo.TableNotFoundException;
import org.hibernatespatial.pojo.TypeMapper;

public class FeatureMapper {
    private final NamingStrategy naming;
    private final TypeMapper typeMapper;

    public FeatureMapper(NamingStrategy naming, TypeMapper typeMapper) {
        this.naming = naming;
        this.typeMapper = typeMapper;
    }

    public ClassInfo createClassInfo(String catalog, String schema, String tableName, DatabaseMetaData dmd) throws TableNotFoundException {
        ClassInfo cInfo;
        block22: {
            ResultSet rs = null;
            boolean empty = true;
            String className = this.naming.createClassName(tableName);
            cInfo = new ClassInfo(tableName, className);
            try {
                rs = dmd.getColumns(catalog, schema, tableName, null);
                while (rs.next()) {
                    empty = false;
                    String colName = rs.getString("COLUMN_NAME");
                    String dbType = rs.getString("TYPE_NAME");
                    int javaType = rs.getInt("DATA_TYPE");
                    AttributeInfo ai = new AttributeInfo();
                    ai.setColumnName(colName);
                    ai.setFieldName(this.naming.createPropertyName(colName));
                    ai.setHibernateType(this.typeMapper.getHibernateType(dbType, javaType));
                    ai.setCtClass(this.typeMapper.getCtClass(dbType, javaType));
                    cInfo.addAttribute(ai);
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (empty) {
                throw new TableNotFoundException(tableName);
            }
            try {
                rs = dmd.getPrimaryKeys(catalog, schema, tableName);
                boolean hasPkey = rs.next();
                if (!hasPkey) break block22;
                String pkn = rs.getString("COLUMN_NAME");
                for (AttributeInfo ai : cInfo.getAttributes()) {
                    if (!ai.getColumnName().equals(pkn)) continue;
                    ai.setIdentifier(true);
                    break;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
        return cInfo;
    }
}

