/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.notification;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.ibu.MigrationContext;
import com.cybelia.sandra.ibu.ReturnCodeHelper;
import com.cybelia.sandra.notifier.SandraNotifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class SandraIbuMailer {
    private static Log log = LogFactory.getLog(SandraIbuMailer.class);
    public static final int COMMANDE_COLUMNS_NUM = 0;
    public static final int SOCIETE_COLUMNS_NUM = 35;

    public static void checkMailsToSend(MigrationContext contextMigration, int returnCode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Integration is finished, checking for mail to send...");
        }
        int mailCount = 0;
        if (ReturnCodeHelper.hasParserError(returnCode)) {
            mailCount += SandraIbuMailer.sendParserErrorMail(contextMigration);
        }
        if (ReturnCodeHelper.hasInjectorError(returnCode)) {
            mailCount += SandraIbuMailer.sendInjectorErrorMail(contextMigration);
        }
        if (ReturnCodeHelper.hasGeneralError(returnCode)) {
            mailCount += SandraIbuMailer.sendGeneralErrorMail(contextMigration);
        }
        if (mailCount > 0 && log.isInfoEnabled()) {
            log.info((Object)(mailCount + " mail(s) sent."));
        }
    }

    private static int sendParserErrorMail(MigrationContext contextMigration) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Prepare parser error mail");
        }
        SandraIbuMailer.createNotification("parserErrorMail", contextMigration, contextMigration.getParserErrorLines());
        return 1;
    }

    private static int sendInjectorErrorMail(MigrationContext contextMigration) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Prepare injector error mail");
        }
        SandraIbuMailer.createNotification("injectorErrorMail", contextMigration, contextMigration.getInjectorErrorLines());
        return 1;
    }

    private static int sendGeneralErrorMail(MigrationContext contextMigration) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Prepare injector error mail");
        }
        SandraIbuMailer.createNotification("generalErrorMail", contextMigration, contextMigration.getLines());
        return 1;
    }

    private static void createNotification(String name, MigrationContext contextMigration, List<String> lines) {
        ArrayList<String> societes = new ArrayList<String>();
        ArrayList<String> commandes = new ArrayList<String>();
        for (String line : lines) {
            String commande = SandraIbuMailer.extractColumn(line, 0).replace("\"", "");
            if (commandes.contains(commande)) continue;
            commandes.add(commande);
            societes.add(SandraIbuMailer.extractColumn(line, 35).replace("\"", ""));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ibu error : " + commandes.size() + " commandes founds " + societes.size() + " societe code found "));
        }
        try {
            new SandraNotifier().notifyEvent(name, SandraSchedulerConfigHelper.getSandraName(SandraConfig.getConfig()), contextMigration.getSourceFileName(), SandraHelper.convertToListForNotifier(contextMigration.getErrorMsgs()), SandraHelper.convertToListForNotifier(commandes), SandraHelper.convertToListForNotifier(societes));
        }
        catch (TopiaException ex) {
            log.error((Object)ex);
        }
    }

    protected static String extractColumn(String line, int i) {
        String[] columns = line.split(";");
        return columns[i];
    }
}

