/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

public class InjectorChauffeur
implements Injector {
    protected Chauffeur chauffeur;

    @Override
    public Chauffeur getObject() {
        return this.chauffeur;
    }

    @Override
    public void clear() {
        this.chauffeur = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO(manager.getTransaction());
        this.chauffeur = chauffeurDAO.findByNaturalId(ibu.getChauffeurCode());
    }

    public void inject(ManagerInjector manager, IbuChauffeur ibuChauffeur) throws TopiaException {
        ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO(manager.getTransaction());
        this.chauffeur = chauffeurDAO.findByNaturalId(ibuChauffeur.getCode());
        if (this.chauffeur == null) {
            this.chauffeur = chauffeurDAO.createByNaturalId(ibuChauffeur.getCode());
        }
        this.chauffeur.setNom(ibuChauffeur.getNom());
        this.chauffeur.setPrenom(ibuChauffeur.getPrenom());
        this.chauffeur.setTrigramme(ibuChauffeur.getTrigramme());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion1());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion2());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion3());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion4());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion5());
        this.addDefautChauffeur(manager, ibuChauffeur.getCamion6());
    }

    private void addDefautChauffeur(ManagerInjector manager, String camionCode) throws TopiaException {
        CamionDAO camionDAO;
        Object camion;
        if (StringUtils.isNotEmpty((CharSequence)camionCode) && (camion = (camionDAO = SandraDAOHelper.getCamionDAO(manager.getTransaction())).findByNaturalId(camionCode, manager.getSociete())) != null) {
            Collection<Chauffeur> defautChauffeurs = camion.getDefautChauffeurs();
            if (defautChauffeurs == null) {
                defautChauffeurs = new ArrayList<Chauffeur>();
                camion.setDefautChauffeurs(defautChauffeurs);
            }
            if (!defautChauffeurs.contains(this.chauffeur)) {
                defautChauffeurs.add(this.chauffeur);
            }
        }
    }
}

