/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.ibu.IbuFileComparator;
import com.cybelia.sandra.ibu.MigrationContext;
import com.cybelia.sandra.ibu.ReturnCodeHelper;
import com.cybelia.sandra.ibu.csv.CSVReaderGeneric;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuAutorisation;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.csv.bean.IbuChauffeur;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurDuplicated;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurGPS;
import com.cybelia.sandra.ibu.csv.bean.IbuEvent;
import com.cybelia.sandra.ibu.csv.bean.IbuLabel;
import com.cybelia.sandra.ibu.csv.bean.IbuTransporteur;
import com.cybelia.sandra.ibu.csv.bean.IbuUser;
import com.cybelia.sandra.ibu.csv.bean.IbuUsine;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderAutorisation;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderCamion;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderChauffeur;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderEleveurDuplicated;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderEleveurGPS;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderEvent;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderIbu;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderLabel;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderTransporteur;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderUser;
import com.cybelia.sandra.ibu.csv.reader.CSVReaderUsine;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.notification.SandraIbuMailer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.DateUtil;
import org.nuiton.util.FileUtil;

public class IBU {
    protected static final Log log = LogFactory.getLog(IBU.class);
    protected String codeSociete;

    public IBU() {
        this.codeSociete = ".*";
    }

    public IBU(String codeSociete) {
        this.codeSociete = codeSociete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectIBU() throws TopiaNotFoundException, IOException {
        ApplicationConfig config = SandraConfig.getConfig();
        String ibuPath = SandraSchedulerConfigHelper.getIbuPath(config);
        String ibuWorkPath = SandraSchedulerConfigHelper.getIbuWorkPath(config);
        String ibuDonePath = SandraSchedulerConfigHelper.getIbuDonePath(config);
        String ibuPatternFile = "^" + this.codeSociete + SandraSchedulerConfigHelper.getPatternFile(config);
        File ibuWorkFile = new File(ibuWorkPath);
        List workFiles = FileUtil.find((File)ibuWorkFile, (String)ibuPatternFile, (boolean)false);
        for (File workFile : workFiles) {
            String ibuFilePath = ibuPath + File.separator + workFile.getName();
            File ibuFile = new File(ibuFilePath);
            try {
                FileUtils.moveFile((File)workFile, (File)ibuFile);
            }
            catch (FileExistsException eee) {
                FileUtils.deleteQuietly((File)workFile);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Injecting path files with template " + ibuPatternFile + " : " + ibuPath));
        }
        File ibuPathFile = new File(ibuPath);
        List files = FileUtil.find((File)ibuPathFile, (String)ibuPatternFile, (boolean)false);
        Collections.sort(files, new IbuFileComparator(ibuPatternFile));
        Date start = new Date();
        ManagerInjector manager = new ManagerInjector();
        ArrayList<Integer> statsByLine = new ArrayList<Integer>();
        for (File f : files) {
            String fileName = f.getName();
            String work = ibuWorkPath + File.separator + fileName;
            File workFile = new File(work);
            try {
                FileUtils.moveFile((File)f, (File)workFile);
            }
            catch (FileExistsException eee) {
                FileUtils.deleteQuietly((File)f);
            }
            log.info((Object)("Injecting : " + fileName));
            try {
                FileInjector<Ibu> fileInjector = new FileInjector<Ibu>((CSVReaderGeneric)new CSVReaderIbu(), workFile, manager){

                    @Override
                    public void inject(ManagerInjector manager, List<Ibu> toInject) {
                        manager.injectIbus(this.contextMigration, toInject);
                    }
                };
                Date startFile = new Date();
                fileInjector.doInject();
                Date endDate = new Date();
                int s = DateUtil.getDifferenceInSeconds((Date)startFile, (Date)endDate);
                int ms = SandraHelper.getDifferenceInMilliseconds(startFile, endDate);
                int size = fileInjector.getNbLines();
                int msByLines = 0;
                if (size > 0) {
                    msByLines = ms / size;
                }
                statsByLine.add(msByLines);
                log.info((Object)("File '" + fileName + "' with " + size + " lines was integrated in " + s + "s : " + msByLines + "ms/lines"));
            }
            finally {
                String done = ibuDonePath + File.separator + fileName;
                File doneFile = new File(done);
                try {
                    FileUtils.moveFile((File)workFile, (File)doneFile);
                }
                catch (FileExistsException eee) {
                    log.warn((Object)("File '" + fileName + "' already in done, delete this one"));
                    FileUtils.deleteQuietly((File)workFile);
                }
            }
        }
        int size = files.size();
        if (log.isInfoEnabled() && size > 0) {
            Date end = new Date();
            int min = DateUtil.getDifferenceInMinutes((Date)start, (Date)end);
            int sum = 0;
            Iterator i$ = statsByLine.iterator();
            while (i$.hasNext()) {
                int stat = (Integer)i$.next();
                sum += stat;
            }
            int average = sum / size;
            log.info((Object)("Injection of " + size + " files executed in " + min + "min : " + average + "ms/lines"));
        }
    }

    public void injectIBUContent(String content) throws TopiaNotFoundException, IOException {
        this.injectIBUContent(new ManagerInjector(), content);
    }

    public void injectIBUContent(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<Ibu> injector = new StringInjector<Ibu>(managerInjector, (CSVReaderGeneric)new CSVReaderIbu(), content){

            @Override
            public void inject(ManagerInjector manager, List<Ibu> toInject) {
                manager.injectIbus(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectLabels(String content) throws TopiaNotFoundException, IOException {
        this.injectLabels(new ManagerInjector(), content);
    }

    public void injectLabels(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuLabel> injector = new StringInjector<IbuLabel>(managerInjector, (CSVReaderGeneric)new CSVReaderLabel(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuLabel> toInject) {
                manager.injectLabels(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectUsines(String content) throws TopiaNotFoundException, IOException {
        this.injectUsines(new ManagerInjector(), content);
    }

    public void injectUsines(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuUsine> injector = new StringInjector<IbuUsine>(managerInjector, (CSVReaderGeneric)new CSVReaderUsine(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuUsine> toInject) {
                manager.injectUsines(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectCamions(String content) throws TopiaNotFoundException, IOException {
        this.injectCamions(new ManagerInjector(), content);
    }

    public void injectCamions(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuCamion> injector = new StringInjector<IbuCamion>(managerInjector, (CSVReaderGeneric)new CSVReaderCamion(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuCamion> toInject) {
                manager.injectCamions(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectChauffeurs(String content) throws TopiaNotFoundException, IOException {
        this.injectChauffeurs(new ManagerInjector(), content);
    }

    public void injectChauffeurs(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuChauffeur> injector = new StringInjector<IbuChauffeur>(managerInjector, (CSVReaderGeneric)new CSVReaderChauffeur(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuChauffeur> toInject) {
                manager.injectChauffeurs(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectTransporteurs(String content) throws TopiaNotFoundException, IOException {
        this.injectTransporteurs(new ManagerInjector(), content);
    }

    public void injectTransporteurs(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuTransporteur> injector = new StringInjector<IbuTransporteur>(managerInjector, (CSVReaderGeneric)new CSVReaderTransporteur(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuTransporteur> toInject) {
                manager.injectTransporteurs(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectAutorisations(String content) throws TopiaNotFoundException, IOException {
        this.injectAutorisations(new ManagerInjector(), content);
    }

    public void injectAutorisations(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuAutorisation> injector = new StringInjector<IbuAutorisation>(managerInjector, (CSVReaderGeneric)new CSVReaderAutorisation(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuAutorisation> toInject) {
                manager.injectAutorisations(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectUsers(String content) throws TopiaNotFoundException, IOException {
        this.injectUsers(new ManagerInjector(), content);
    }

    public void injectUsers(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuUser> injector = new StringInjector<IbuUser>(managerInjector, (CSVReaderGeneric)new CSVReaderUser(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuUser> toInject) {
                manager.injectUsers(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectEvents(String content) throws TopiaNotFoundException, IOException {
        this.injectEvents(new ManagerInjector(), content);
    }

    public void injectEvents(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuEvent> injector = new StringInjector<IbuEvent>(managerInjector, (CSVReaderGeneric)new CSVReaderEvent(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuEvent> toInject) {
                manager.injectEvents(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectEleveurGPS(String content) throws TopiaNotFoundException, IOException {
        this.injectEleveurGPS(new ManagerInjector(), content);
    }

    public void injectEleveurGPS(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuEleveurGPS> injector = new StringInjector<IbuEleveurGPS>(managerInjector, (CSVReaderGeneric)new CSVReaderEleveurGPS(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuEleveurGPS> toInject) {
                manager.injectEleveurGPS(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    public void injectEleveurDuplicated(String content) throws TopiaNotFoundException, IOException {
        this.injectEleveurDuplicated(new ManagerInjector(), content);
    }

    public void injectEleveurDuplicated(ManagerInjector managerInjector, String content) throws TopiaNotFoundException, IOException {
        StringInjector<IbuEleveurDuplicated> injector = new StringInjector<IbuEleveurDuplicated>(managerInjector, (CSVReaderGeneric)new CSVReaderEleveurDuplicated(), content){

            @Override
            public void inject(ManagerInjector manager, List<IbuEleveurDuplicated> toInject) {
                manager.injectEleveurDuplicated(this.contextMigration, toInject);
            }
        };
        injector.doInject();
    }

    protected void endInjection(MigrationContext contextMigration) {
        if (contextMigration.getErrorBaseFileName() == null) {
            contextMigration.setErrorFilePath(SandraSchedulerConfigHelper.getIbuErrorPath(SandraConfig.getConfig()));
        }
        try {
            int returnCode = 0;
            returnCode |= this.createFilesAndGetReturnCode(contextMigration);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Return code is : " + returnCode));
            }
            SandraIbuMailer.checkMailsToSend(contextMigration, returnCode);
        }
        catch (Exception ex) {
            log.error((Object)"Mails are not send caused by : ", (Throwable)ex);
        }
    }

    protected int createFilesAndGetReturnCode(MigrationContext contextMigration) throws Exception {
        boolean hasParserError = this.createParserErrorFile(contextMigration);
        boolean hasInjectorError = this.createInjectorErrorFile(contextMigration);
        return ReturnCodeHelper.getReturnCode(hasParserError, hasInjectorError);
    }

    protected boolean createParserErrorFile(MigrationContext contextMigration) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking for a parser error file to write...");
        }
        String errorFileName = contextMigration.getParserErrorFilePath();
        List<Integer> errorLineNumbers = contextMigration.getParserErrorLineNumbers();
        return this.createErrorFile(contextMigration, errorLineNumbers, errorFileName);
    }

    protected boolean createInjectorErrorFile(MigrationContext contextMigration) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking for an injector error file to write...");
        }
        String errorFileName = contextMigration.getInjectorErrorFilePath();
        List<Integer> errorLineNumbers = contextMigration.getInjectorErrorLineNumbers();
        return this.createErrorFile(contextMigration, errorLineNumbers, errorFileName);
    }

    protected boolean createErrorFile(MigrationContext contextMigration, List<Integer> errorLineNumbers, String errorFileName) throws Exception {
        if (!errorLineNumbers.isEmpty() && errorFileName != null && !"".equals(errorFileName)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("... writing to file: " + errorFileName));
            }
            List<String> lines = contextMigration.getLines();
            String fileContent = lines.get(0);
            for (Integer i : errorLineNumbers) {
                fileContent = fileContent + lines.get(i);
            }
            File errorFile = new File(errorFileName);
            FileUtils.writeStringToFile((File)errorFile, (String)fileContent);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"... Nothing to do.");
        }
        return false;
    }

    protected abstract class StringInjector<E>
    extends AbstractInjector<E> {
        protected String content;

        protected StringInjector(ManagerInjector manager, CSVReaderGeneric<E> reader, String content) throws TopiaNotFoundException, IOException {
            super(reader, manager);
            this.content = content;
            if (this.contextMigration.getErrorBaseFileName() == null) {
                this.contextMigration.setFilePath("installEvents");
                this.contextMigration.setErrorFilePath("log");
            }
        }

        @Override
        public Reader getReader() {
            ByteArrayInputStream stream = new ByteArrayInputStream(this.content.getBytes());
            return new InputStreamReader(stream);
        }
    }

    protected abstract class FileInjector<E>
    extends AbstractInjector<E> {
        protected File file;

        protected FileInjector(CSVReaderGeneric<E> reader, File file, ManagerInjector manager) {
            super(reader, manager);
            this.file = file;
            this.contextMigration.setSourceFileName(file.getName());
        }

        @Override
        public Reader getReader() {
            try {
                return new FileReader(this.file);
            }
            catch (FileNotFoundException eee) {
                log.error((Object)("Failed to read file " + this.file.getName()), (Throwable)eee);
                return null;
            }
        }
    }

    protected abstract class AbstractInjector<E>
    implements Injector<E> {
        protected ManagerInjector manager;
        protected MigrationContext contextMigration;
        protected CSVReaderGeneric<E> reader;
        protected List<E> toInject;

        protected AbstractInjector(CSVReaderGeneric<E> reader, ManagerInjector manager) {
            this.reader = reader;
            this.contextMigration = new MigrationContext();
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doInject() {
            try {
                this.toInject = this.reader.parse(this.contextMigration, this.getReader());
                this.inject(this.manager, this.toInject);
            }
            catch (Exception ex) {
                try {
                    log.error((Object)"Injection failed : ", (Throwable)ex);
                    IBU.this.createInjectorErrorFile(this.contextMigration);
                }
                catch (Exception ex1) {
                    log.error((Object)"Creating mail error failed : ", (Throwable)ex1);
                }
            }
            finally {
                if (this.manager != null) {
                    try {
                        this.manager.finalize();
                    }
                    catch (Throwable t) {
                        log.fatal((Object)"Cannot close manager", t);
                    }
                }
                IBU.this.endInjection(this.contextMigration);
            }
        }

        public int getNbLines() {
            return this.toInject.size();
        }

        public abstract Reader getReader();
    }

    protected static interface Injector<E> {
        public void inject(ManagerInjector var1, List<E> var2);

        public void doInject();
    }
}

