/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.SchedulerJobFactory;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.ibu.IBU;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.ApplicationConfig;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SandraScheduler {
    public static final Log log = LogFactory.getLog(SandraScheduler.class);
    public static final String LOGGER_JOB = "loggerJob";
    public static final String CODE_SOCIETE = "codeSociete";

    public static void main(String[] args) throws Exception {
        ApplicationConfig config = SandraConfig.getConfig(args);
        I18n.init((I18nInitializer)new DefaultI18nInitializer("sandra-scheduler-i18n"), (Locale)SandraSchedulerConfigHelper.getLocale(config));
        Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
        for (SchedulerJobFactory.SchedulerJobClass sandraScheduler : SchedulerJobFactory.SchedulerJobClass.values()) {
            String pattern = sandraScheduler.getPattern();
            String cronExpression = SandraSchedulerConfigHelper.getCronfromProperies(config, pattern);
            if (StringUtils.isEmpty((CharSequence)cronExpression)) {
                log.warn((Object)("No cron found for notification : " + I18n._((String)pattern, (Object[])new Object[0])));
                continue;
            }
            CronTrigger cronTrigger = new CronTrigger(pattern, "DEFAULT", cronExpression);
            Class<? extends SchedulerJobFactory.SchedulerJob> schedulerClass = sandraScheduler.getSchedulerClass();
            JobDetail jobDetail = new JobDetail(pattern, "DEFAULT", schedulerClass, false, true, true);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("sandraScheduler", pattern);
            jobDetail.setJobDataMap(jobDataMap);
            log.info((Object)(I18n._((String)pattern, (Object[])new Object[0]) + " will start at : " + SandraSchedulerConfigHelper.getNextDatefromProperies(config, pattern)));
            scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        }
        List<Societe> societes = SandraScheduler.getAllSociete();
        for (Societe societe : societes) {
            String pattern = societe.getCode() + "-" + "sandra.scheduler.ibu";
            String cronExpression = SandraSchedulerConfigHelper.getCronfromProperies(config, "sandra.scheduler.ibu");
            if (cronExpression == null) continue;
            CronTrigger cronTrigger = new CronTrigger(pattern, "DEFAULT", cronExpression);
            JobDetail jobDetail = new JobDetail(pattern, "DEFAULT", IbuSchedulerJob.class, false, true, true);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("sandraScheduler", pattern);
            jobDataMap.put(CODE_SOCIETE, societe.getCode());
            jobDetail.setJobDataMap(jobDataMap);
            log.info((Object)(I18n._((String)pattern, (Object[])new Object[0]) + " will start at for societe " + societe.getCode() + " : " + SandraSchedulerConfigHelper.getNextDatefromProperies(config, "sandra.scheduler.ibu")));
            scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        }
        if (log.isDebugEnabled()) {
            JobDetail loggerJob = new JobDetail(LOGGER_JOB, "DEFAULT", LogJob.class);
            SimpleTrigger loggerTrigger = new SimpleTrigger(LOGGER_JOB, -1, 600000L);
            scheduler.scheduleJob(loggerJob, (Trigger)loggerTrigger);
        }
        scheduler.start();
    }

    public static List<Societe> getAllSociete() {
        try {
            TopiaContext ibuRootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
            TopiaContext transaction = ibuRootContext.beginTransaction();
            SocieteDAO societeDAO = null;
            societeDAO = SandraDAOHelper.getSocieteDAO(transaction);
            return societeDAO.findAll();
        }
        catch (Exception eee) {
            log.error((Object)"Failed to get all societe", (Throwable)eee);
            return null;
        }
    }

    public static class LogJob
    implements StatefulJob {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            try {
                String[] groups;
                Scheduler scheduler = jobExecutionContext.getScheduler();
                for (String group : groups = scheduler.getJobGroupNames()) {
                    String[] jobNames;
                    for (String jobName : jobNames = scheduler.getJobNames(group)) {
                        if (jobName.equals(SandraScheduler.LOGGER_JOB)) continue;
                        Trigger trigger = scheduler.getTrigger(jobName, group);
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                        String msg = "[" + jobName + "] " + dateFormat.format(trigger.getNextFireTime());
                        int triggerState = scheduler.getTriggerState(jobName, group);
                        switch (triggerState) {
                            case 4: {
                                msg = msg + " is blocked";
                                break;
                            }
                            case 2: {
                                msg = msg + " is completed";
                                break;
                            }
                            case 3: {
                                msg = msg + " is on error";
                                break;
                            }
                            case -1: {
                                msg = msg + " is none";
                                break;
                            }
                            case 0: {
                                msg = msg + " is normal";
                                break;
                            }
                            case 1: {
                                msg = msg + " is in pause";
                            }
                        }
                        log.info((Object)msg);
                    }
                }
            }
            catch (SchedulerException e) {
                log.info((Object)"Failled to get all jobs");
            }
        }
    }

    public static class IbuSchedulerJob
    implements StatefulJob {
        public static final String PATTERN = "sandra.scheduler.ibu";

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            String codeSociete = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)SandraScheduler.CODE_SOCIETE);
            IBU ibu = new IBU(codeSociete);
            try {
                ibu.injectIBU();
            }
            catch (Exception eee) {
                log.error((Object)("Failed to run ibu for societe " + codeSociete), (Throwable)eee);
            }
        }
    }
}

