/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.notifier.SandraNotifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.ApplicationConfig;

public class EmailHelper {
    private static final Log log = LogFactory.getLog(EmailHelper.class);

    public static void sendEmail(String[] to, String subject, String msg, String ... attachments) {
        log.info((Object)("Mail will sent to subject : " + subject + " to " + Arrays.toString(to)));
        ApplicationConfig config = SandraConfig.getConfig();
        MultiPartEmail email = new MultiPartEmail();
        email.setHostName(SandraSchedulerConfigHelper.getSandraEmailHost(config));
        email.setSmtpPort(SandraSchedulerConfigHelper.getSandraEmailPort(config));
        email.setSubject(subject);
        try {
            email.setFrom(SandraSchedulerConfigHelper.getSandraEmailForm(config));
            for (String recipient : to) {
                email.addTo(recipient);
            }
            String charset = "UTF-8";
            email.setCharset(charset);
            email.addPart(msg, "text/plain");
            for (String attachmentPath : attachments) {
                EmailAttachment attachment = new EmailAttachment();
                attachment.setPath(attachmentPath);
                email.attach(attachment);
            }
            email.send();
            log.info((Object)("Mail sent subject : " + subject + " to " + Arrays.toString(to)));
        }
        catch (EmailException e) {
            String msgErr = "EmailException impossible d'envoyer le mail";
            log.fatal((Object)msgErr, (Throwable)e);
            throw new RuntimeException(msgErr, e);
        }
    }

    public static void sendEmail(String to, String subject, String message, String ... attachments) {
        EmailHelper.sendEmail(new String[]{to}, subject, message, attachments);
    }

    public static void sendEmailToAdmin(String subject, String message, String ... attachments) {
        EmailHelper.sendEmail(SandraSchedulerConfigHelper.getSandraEmailTo(SandraConfig.getConfig()), subject, message, attachments);
    }

    public static void sendNotification(String name, List<String[]> datas) {
        try {
            List<List<String>> reformatData = SandraHelper.reformatData(datas);
            String etapeTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(0));
            String eleveurTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(1));
            String tourTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(2));
            String camionTopiaIdsAsString = SandraHelper.convertToListForNotifier((Collection)reformatData.get(3));
            ApplicationConfig config = SandraConfig.getConfig();
            SandraNotifier sandraNotifier = new SandraNotifier();
            sandraNotifier.notifyEvent(name, SandraSchedulerConfigHelper.getSandraName(config), SandraSchedulerConfigHelper.getSandraUrl(config), etapeTopiaIdsAsString, eleveurTopiaIdsAsString, tourTopiaIdsAsString, camionTopiaIdsAsString);
        }
        catch (TopiaException ex) {
            log.error((Object)"TopiaException : ", (Throwable)ex);
        }
    }
}

