/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.trace.SuiviTour;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class TourAbstract
extends TopiaEntityAbstract
implements Tour {
    protected Date dateLivraison;
    protected int numero;
    protected String commentaire;
    protected Date dateChargement;
    protected boolean actif;
    protected List<Etape> etapes;
    protected Camion camion;
    protected Chauffeur defautChauffeur;
    protected SuiviTour suiviTour;
    private static final long serialVersionUID = 7148445389700871986L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "dateLivraison", Date.class, (Object)this.dateLivraison);
        visitor.visit((TopiaEntity)this, "numero", Integer.TYPE, (Object)this.numero);
        visitor.visit((TopiaEntity)this, "commentaire", String.class, (Object)this.commentaire);
        visitor.visit((TopiaEntity)this, "dateChargement", Date.class, (Object)this.dateChargement);
        visitor.visit((TopiaEntity)this, "actif", Boolean.TYPE, (Object)this.actif);
        visitor.visit((TopiaEntity)this, "etapes", List.class, Etape.class, this.etapes);
        visitor.visit((TopiaEntity)this, "camion", Camion.class, (Object)this.camion);
        visitor.visit((TopiaEntity)this, "defautChauffeur", Chauffeur.class, (Object)this.defautChauffeur);
        visitor.visit((TopiaEntity)this, "suiviTour", SuiviTour.class, (Object)this.suiviTour);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setDateLivraison(Date dateLivraison) {
        Date oldValue = this.dateLivraison;
        this.fireOnPreWrite("dateLivraison", oldValue, dateLivraison);
        this.dateLivraison = dateLivraison;
        this.fireOnPostWrite("dateLivraison", oldValue, dateLivraison);
    }

    @Override
    public Date getDateLivraison() {
        this.fireOnPreRead("dateLivraison", this.dateLivraison);
        Date result = this.dateLivraison;
        this.fireOnPostRead("dateLivraison", this.dateLivraison);
        return result;
    }

    @Override
    public void setNumero(int numero) {
        int oldValue = this.numero;
        this.fireOnPreWrite("numero", oldValue, numero);
        this.numero = numero;
        this.fireOnPostWrite("numero", oldValue, numero);
    }

    @Override
    public int getNumero() {
        this.fireOnPreRead("numero", this.numero);
        int result = this.numero;
        this.fireOnPostRead("numero", this.numero);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        this.fireOnPreWrite("commentaire", oldValue, commentaire);
        this.commentaire = commentaire;
        this.fireOnPostWrite("commentaire", oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        this.fireOnPreRead("commentaire", this.commentaire);
        String result = this.commentaire;
        this.fireOnPostRead("commentaire", this.commentaire);
        return result;
    }

    @Override
    public void setDateChargement(Date dateChargement) {
        Date oldValue = this.dateChargement;
        this.fireOnPreWrite("dateChargement", oldValue, dateChargement);
        this.dateChargement = dateChargement;
        this.fireOnPostWrite("dateChargement", oldValue, dateChargement);
    }

    @Override
    public Date getDateChargement() {
        this.fireOnPreRead("dateChargement", this.dateChargement);
        Date result = this.dateChargement;
        this.fireOnPostRead("dateChargement", this.dateChargement);
        return result;
    }

    @Override
    public void setActif(boolean actif) {
        boolean oldValue = this.actif;
        this.fireOnPreWrite("actif", oldValue, actif);
        this.actif = actif;
        this.fireOnPostWrite("actif", oldValue, actif);
    }

    @Override
    public boolean isActif() {
        this.fireOnPreRead("actif", this.actif);
        boolean result = this.actif;
        this.fireOnPostRead("actif", this.actif);
        return result;
    }

    @Override
    public boolean getActif() {
        this.fireOnPreRead("actif", this.actif);
        boolean result = this.actif;
        this.fireOnPostRead("actif", this.actif);
        return result;
    }

    @Override
    public void addEtapes(Etape etapes) {
        this.fireOnPreWrite("etapes", null, etapes);
        if (this.etapes == null) {
            this.etapes = new ArrayList<Etape>();
        }
        etapes.setTour(this);
        this.etapes.add(etapes);
        this.fireOnPostWrite("etapes", this.etapes.size(), null, etapes);
    }

    @Override
    public void addAllEtapes(List<Etape> etapes) {
        if (etapes == null) {
            return;
        }
        for (Etape item : etapes) {
            this.addEtapes(item);
        }
    }

    @Override
    public void setEtapes(List<Etape> etapes) {
        ArrayList<Etape> oldValue = this.etapes != null ? new ArrayList<Etape>(this.etapes) : null;
        this.fireOnPreWrite("etapes", oldValue, etapes);
        this.etapes = etapes;
        this.fireOnPostWrite("etapes", oldValue, etapes);
    }

    @Override
    public void removeEtapes(Etape etapes) {
        this.fireOnPreWrite("etapes", etapes, null);
        if (this.etapes == null || !this.etapes.remove(etapes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        etapes.setTour(null);
        this.fireOnPostWrite("etapes", this.etapes.size() + 1, etapes, null);
    }

    @Override
    public void clearEtapes() {
        if (this.etapes == null) {
            return;
        }
        for (Etape item : this.etapes) {
            item.setTour(null);
        }
        ArrayList<Etape> oldValue = new ArrayList<Etape>(this.etapes);
        this.fireOnPreWrite("etapes", oldValue, this.etapes);
        this.etapes.clear();
        this.fireOnPostWrite("etapes", oldValue, this.etapes);
    }

    @Override
    public List<Etape> getEtapes() {
        return this.etapes;
    }

    @Override
    public Etape getEtapesByTopiaId(String topiaId) {
        return (Etape)TopiaEntityHelper.getEntityByTopiaId(this.etapes, (String)topiaId);
    }

    @Override
    public int sizeEtapes() {
        if (this.etapes == null) {
            return 0;
        }
        return this.etapes.size();
    }

    @Override
    public boolean isEtapesEmpty() {
        int size = this.sizeEtapes();
        return size == 0;
    }

    @Override
    public void setCamion(Camion camion) {
        Camion oldValue = this.camion;
        this.fireOnPreWrite("camion", oldValue, camion);
        this.camion = camion;
        this.fireOnPostWrite("camion", oldValue, camion);
    }

    @Override
    public Camion getCamion() {
        this.fireOnPreRead("camion", this.camion);
        Camion result = this.camion;
        this.fireOnPostRead("camion", this.camion);
        return result;
    }

    @Override
    public void setDefautChauffeur(Chauffeur defautChauffeur) {
        Chauffeur oldValue = this.defautChauffeur;
        this.fireOnPreWrite("defautChauffeur", oldValue, defautChauffeur);
        this.defautChauffeur = defautChauffeur;
        this.fireOnPostWrite("defautChauffeur", oldValue, defautChauffeur);
    }

    @Override
    public Chauffeur getDefautChauffeur() {
        this.fireOnPreRead("defautChauffeur", this.defautChauffeur);
        Chauffeur result = this.defautChauffeur;
        this.fireOnPostRead("defautChauffeur", this.defautChauffeur);
        return result;
    }

    @Override
    public void setSuiviTour(SuiviTour suiviTour) {
        SuiviTour oldValue = this.suiviTour;
        this.fireOnPreWrite("suiviTour", oldValue, suiviTour);
        this.suiviTour = suiviTour;
        this.fireOnPostWrite("suiviTour", oldValue, suiviTour);
    }

    @Override
    public SuiviTour getSuiviTour() {
        this.fireOnPreRead("suiviTour", this.suiviTour);
        SuiviTour result = this.suiviTour;
        this.fireOnPostRead("suiviTour", this.suiviTour);
        return result;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (this.getEtapes() != null) {
            tmp.addAll(this.getEtapes());
        }
        tmp.add(this.getSuiviTour());
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("dateLivraison", (Object)this.dateLivraison).append("numero", this.numero).append("commentaire", (Object)this.commentaire).append("dateChargement", (Object)this.dateChargement).append("actif", this.actif).append("camion", (Object)this.camion).append("defautChauffeur", (Object)this.defautChauffeur).append("suiviTour", (Object)this.suiviTour).toString();
        return result;
    }
}

