/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EtapeDAOAbstract<E extends Etape>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Etape.class;
    }

    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Etape;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(LigneProduit.class).findAllByProperties("etape", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getEtape())) continue;
            item.setEtape(null);
        }
        list = this.getContext().getDAO(SuiviEtape.class).findAllByProperties("etape", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getEtape())) continue;
            item.setEtape(null);
        }
        super.delete(entity);
    }

    public E findByNaturalId(int ordre, Tour tour, Eleveur eleveur) throws TopiaException {
        return (E)((Etape)this.findByProperties("ordre", ordre, new Object[]{"tour", tour, "eleveur", eleveur}));
    }

    public boolean existByNaturalId(int ordre, Tour tour, Eleveur eleveur) throws TopiaException {
        return this.existByProperties("ordre", ordre, new Object[]{"tour", tour, "eleveur", eleveur});
    }

    @Deprecated
    public E create(int ordre, Tour tour, Eleveur eleveur) throws TopiaException {
        return (E)((Etape)this.create(new Object[]{"ordre", ordre, "tour", tour, "eleveur", eleveur}));
    }

    public E createByNaturalId(int ordre, Tour tour, Eleveur eleveur) throws TopiaException {
        return (E)((Etape)this.create(new Object[]{"ordre", ordre, "tour", tour, "eleveur", eleveur}));
    }

    public E createByNotNull(int ordre, Tour tour, Eleveur eleveur) throws TopiaException {
        return (E)((Etape)this.create(new Object[]{"ordre", ordre, "tour", tour, "eleveur", eleveur}));
    }

    public E findByOrdre(int v) throws TopiaException {
        Etape result = (Etape)this.findByProperty("ordre", v);
        return (E)result;
    }

    public List<E> findAllByOrdre(int v) throws TopiaException {
        List result = this.findAllByProperty("ordre", v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        Etape result = (Etape)this.findByProperty("commentaire", v);
        return (E)result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List result = this.findAllByProperty("commentaire", v);
        return result;
    }

    public E findByEtat(int v) throws TopiaException {
        Etape result = (Etape)this.findByProperty("etat", v);
        return (E)result;
    }

    public List<E> findAllByEtat(int v) throws TopiaException {
        List result = this.findAllByProperty("etat", v);
        return result;
    }

    public E findByTour(Tour v) throws TopiaException {
        Etape result = (Etape)this.findByProperty("tour", v);
        return (E)result;
    }

    public List<E> findAllByTour(Tour v) throws TopiaException {
        List result = this.findAllByProperty("tour", v);
        return result;
    }

    public E findByEleveur(Eleveur v) throws TopiaException {
        Etape result = (Etape)this.findByProperty("eleveur", v);
        return (E)result;
    }

    public List<E> findAllByEleveur(Eleveur v) throws TopiaException {
        List result = this.findAllByProperty("eleveur", v);
        return result;
    }

    public E findContainsProduits(LigneProduit v) throws TopiaException {
        Etape result = (Etape)this.findContains("produits", v);
        return (E)result;
    }

    public List<E> findAllContainsProduits(LigneProduit v) throws TopiaException {
        List result = this.findAllContains("produits", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == LigneProduit.class) {
            dao = (LigneProduitDAO)this.getContext().getDAO(LigneProduit.class);
            tmp = dao.findAllByEtape((Etape)entity);
            result.addAll(tmp);
        }
        if (type == Tour.class) {
            dao = (TourDAO)this.getContext().getDAO(Tour.class);
            tmp = dao.findAllContainsEtapes((Etape)entity);
            result.addAll(tmp);
        }
        if (type == SuiviEtape.class) {
            dao = (SuiviEtapeDAO)this.getContext().getDAO(SuiviEtape.class);
            tmp = dao.findAllByEtape((Etape)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);
        List<Object> list = this.findUsages(LigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(LigneProduit.class, list);
        }
        if (!(list = this.findUsages(Tour.class, entity)).isEmpty()) {
            result.put(Tour.class, list);
        }
        if (!(list = this.findUsages(SuiviEtape.class, entity)).isEmpty()) {
            result.put(SuiviEtape.class, list);
        }
        return result;
    }
}

