/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

public abstract class ByteSetter {
    public abstract void set(byte var1, int var2);

    public static class StringByteSetter
    extends ByteSetter {
        protected static final char[] hextypes = "0123456789ABCDEF".toCharArray();
        private char[] rep;

        public StringByteSetter(int n) {
            this.rep = new char[n * 2];
        }

        public void set(byte by, int n) {
            this.rep[n *= 2] = hextypes[by >>> 4 & 0xF];
            this.rep[n + 1] = hextypes[by & 0xF];
        }

        public char[] resultAsArray() {
            return this.rep;
        }

        public String result() {
            return new String(this.rep);
        }

        public String toString() {
            return new String(this.rep);
        }
    }

    public static class BinaryByteSetter
    extends ByteSetter {
        private byte[] array;

        public BinaryByteSetter(int n) {
            this.array = new byte[n];
        }

        public void set(byte by, int n) {
            this.array[n] = by;
        }

        public byte[] result() {
            return this.array;
        }

        public String toString() {
            char[] cArray = new char[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                cArray[i] = (char)(this.array[i] & 0xFF);
            }
            return new String(cArray);
        }
    }
}

