/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.security;

import java.util.ArrayList;
import java.util.Collection;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;

public class NotifierSecurityHelper {
    public static String PROFIL_ADMIN = "admin-";

    public static boolean isAdminProfil(String topiaIdProfil) throws TopiaNotFoundException {
        return topiaIdProfil.startsWith(PROFIL_ADMIN);
    }

    public static String[] getAuthorizations(TaasUser user) throws TopiaException {
        ArrayList<String> loadAuthorizations = new ArrayList<String>();
        if (user != null) {
            Collection principals = user.getPrincipals();
            for (TaasPrincipal principal : principals) {
                if (!principal.getName().equals(user.getLogin())) continue;
                Collection authorizations = principal.getAuthorizations();
                for (TaasAuthorization authorization : authorizations) {
                    int actions = authorization.getActions();
                    String expression = authorization.getExpression();
                    if ((actions & 1) != 1) continue;
                    loadAuthorizations.add(expression);
                }
            }
        }
        return loadAuthorizations.toArray(new String[0]);
    }

    public static boolean isAdmin(TaasUser user) {
        Collection principals = user.getPrincipals();
        for (TaasPrincipal principal : principals) {
            Collection authorizations = principal.getAuthorizations();
            for (TaasAuthorization authorization : authorizations) {
                int actions = authorization.getActions();
                String expression = authorization.getExpression();
                if ((actions & 1) != 1 || !expression.equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAdminProfilName(String topiaIdProfil) throws TopiaNotFoundException {
        return NotifierSecurityHelper.getAdminProfilClass(TopiaId.getClassName((String)topiaIdProfil));
    }

    public static String getAdminProfilRecipient(String recipient) throws TopiaNotFoundException {
        return NotifierSecurityHelper.getAdminProfilValue(recipient);
    }

    public static String getTopiaIdRecipient(String recipient) throws TopiaNotFoundException {
        return recipient.replace(PROFIL_ADMIN, "");
    }

    public static String getAdminProfilClass(Class classProfil) {
        return NotifierSecurityHelper.getAdminProfilValue(classProfil.getName());
    }

    public static String getAdminProfilValue(String name) {
        if (name != null && !"".equals(name)) {
            return PROFIL_ADMIN + name;
        }
        return null;
    }
}

