/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.InfoChargementDAO;
import com.cybelia.sandra.ibu.ModifsCollector;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorInfoChargement
implements Injector {
    protected InfoChargement infoChargement;
    private boolean infoChargementChanged;

    public InfoChargement getObject() {
        return this.infoChargement;
    }

    public boolean isInfoChargementChanged() {
        return this.infoChargementChanged;
    }

    @Override
    public void clear() {
        this.infoChargement = null;
        this.infoChargementChanged = false;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        InfoChargementDAO chargementDAO = SandraDAOHelper.getInfoChargementDAO((TopiaContext)manager.getTransaction());
        this.infoChargement = manager.getLigneProduit().getInfoChargement();
        if (this.infoChargement == null) {
            this.infoChargement = (InfoChargement)chargementDAO.create(new Object[0]);
            manager.getLigneProduit().setInfoChargement(this.infoChargement);
            this.infoChargementChanged = true;
        }
        if (!this.infoChargementChanged) {
            ModifsCollector modifsCollector = new ModifsCollector();
            modifsCollector.add(InfoChargement.class, "date", this.infoChargement.getDate(), ibu.getChargementDate());
            modifsCollector.add(InfoChargement.class, "compartiments", this.infoChargement.getCompartiments(), ibu.getChargementCompartiments());
            modifsCollector.add(InfoChargement.class, "quantite", this.infoChargement.getQuantite(), ibu.getProduitQuantiteLivree());
            if (modifsCollector.isModified()) {
                this.infoChargementChanged = true;
            }
        }
        this.infoChargement.setNotifier(this.infoChargementChanged);
        this.infoChargement.setDate(ibu.getChargementDate());
        this.infoChargement.setCompartiments(ibu.getChargementCompartiments());
        this.infoChargement.setQuantite(ibu.getProduitQuantiteLivree());
    }
}

