/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

import com.github.miachm.sods.Color;
import com.github.miachm.sods.ColumnStyle;
import com.github.miachm.sods.NotAnOdsException;
import com.github.miachm.sods.OperationNotSupportedException;
import com.github.miachm.sods.Pair;
import com.github.miachm.sods.Range;
import com.github.miachm.sods.RowStyle;
import com.github.miachm.sods.Sheet;
import com.github.miachm.sods.SpreadSheet;
import com.github.miachm.sods.Style;
import com.github.miachm.sods.Uncompressor;
import com.github.miachm.sods.Vector;
import com.github.miachm.sods.XmlReader;
import com.github.miachm.sods.XmlReaderEventImpl;
import com.github.miachm.sods.XmlReaderInstance;
import com.github.miachm.sods.XmlReaderInstanceEventImpl;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class OdsReader {
    private static final String CORRECT_MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";
    private static final String MANIFEST_PATH = "META-INF/manifest.xml";
    private static final Locale defaultLocal = Locale.US;
    private Uncompressor uncompressor;
    private XmlReader reader = new XmlReaderEventImpl();
    private SpreadSheet spread;
    private Map<String, Style> styles = new HashMap<String, Style>();
    private Map<Integer, Style> rows_styles = new HashMap<Integer, Style>();
    private Map<Integer, Style> columns_styles = new HashMap<Integer, Style>();
    private Map<String, ColumnStyle> styleColumn = new HashMap<String, ColumnStyle>();
    private Map<String, RowStyle> styleRow = new HashMap<String, RowStyle>();
    private Set<Pair<Vector, Vector>> groupCells = new HashSet<Pair<Vector, Vector>>();

    private OdsReader(InputStream in, SpreadSheet spread) {
        this.spread = spread;
        this.styles.put("Default", new Style());
        this.uncompressor = new Uncompressor(in);
    }

    static void load(InputStream in, SpreadSheet spread) throws IOException {
        OdsReader reader = new OdsReader(in, spread);
        reader.load();
    }

    private void load() throws IOException {
        boolean mimetypeChecked = false;
        String entry = this.uncompressor.nextFile();
        while (entry != null) {
            if (entry.endsWith(".xml")) {
                this.processContent();
            } else if (entry.equals("mimetype")) {
                this.checkMimeType();
                mimetypeChecked = true;
            }
            entry = this.uncompressor.nextFile();
        }
        this.uncompressor.close();
        if (!mimetypeChecked) {
            throw new NotAnOdsException("This file doesn't contain a mimetype");
        }
    }

    private void checkMimeType() throws IOException {
        byte[] buff = new byte[CORRECT_MIMETYPE.getBytes().length];
        this.uncompressor.getInputStream().read(buff);
        String mimetype = new String(buff);
        if (!mimetype.equals(CORRECT_MIMETYPE)) {
            throw new NotAnOdsException("This file doesn't look like an ODS file. Mimetype: " + mimetype);
        }
    }

    private void processContent() throws IOException {
        InputStream in = this.uncompressor.getInputStream();
        XmlReaderInstanceEventImpl instance = this.reader.load(in);
        if (instance == null) {
            return;
        }
        XmlReaderInstance styles = instance.nextElement("office:automatic-styles");
        this.iterateStyleEntries(styles);
        XmlReaderInstance content = instance.nextElement("office:body");
        this.iterateFilesEntries(content);
        this.reader.close();
    }

    private void iterateStyleEntries(XmlReaderInstance reader) {
        if (reader == null) {
            return;
        }
        while (reader.hasNext()) {
            Object style;
            XmlReaderInstance instance = reader.nextElement("style:style");
            if (instance == null) {
                return;
            }
            String name = instance.getAttribValue("style:name");
            String family = instance.getAttribValue("style:family");
            if (name == null || family == null) continue;
            if (family.equals("table-cell")) {
                style = this.readCellStyleEntry(instance);
                this.styles.put(name, (Style)style);
                continue;
            }
            if (family.equals("table-column")) {
                style = this.readColumnStyleEntry(instance);
                this.styleColumn.put(name, (ColumnStyle)style);
                continue;
            }
            if (!family.equals("table-row")) continue;
            style = this.readRowStyleEntry(instance);
            this.styleRow.put(name, (RowStyle)style);
        }
    }

    private Style readCellStyleEntry(XmlReaderInstance reader) {
        Style style = new Style();
        while (reader.hasNext()) {
            String backgroundColor;
            XmlReaderInstance instance = reader.nextElement("style:text-properties", "style:table-cell-properties");
            if (instance == null) {
                return style;
            }
            if (instance.getTag().equals("style:text-properties")) {
                String fontsize;
                String fontcolor;
                String underline;
                String italic;
                String bold = instance.getAttribValue("fo:font-weight");
                if (bold != null) {
                    style.setBold(bold.equals("bold"));
                }
                if ((italic = instance.getAttribValue("fo:font-style")) != null) {
                    style.setItalic(italic.equals("italic"));
                }
                if ((underline = instance.getAttribValue("style:text-underline-style")) != null) {
                    style.setUnderline(underline.equals("solid"));
                }
                if ((fontcolor = instance.getAttribValue("fo:color")) != null && !fontcolor.equals("transparent")) {
                    try {
                        style.setFontColor(new Color(fontcolor));
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(e.getMessage());
                    }
                }
                if ((fontsize = instance.getAttribValue("fo:font-size")) != null) {
                    if (fontsize.endsWith("pt")) {
                        int index = fontsize.lastIndexOf("pt");
                        int fontSize = Integer.parseInt(fontsize.substring(0, index));
                        style.setFontSize(fontSize);
                    } else {
                        throw new OperationNotSupportedException("Error, font size is not measured in PT. Skipping...");
                    }
                }
            }
            if (!instance.getTag().equals("style:table-cell-properties") || (backgroundColor = instance.getAttribValue("fo:background-color")) == null || backgroundColor.equals("transparent")) continue;
            try {
                style.setBackgroundColor(new Color(backgroundColor));
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
            }
        }
        return style;
    }

    private ColumnStyle readColumnStyleEntry(XmlReaderInstance reader) {
        ColumnStyle style = new ColumnStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-column-properties");
            if (instance == null) {
                return style;
            }
            String columnWidth = instance.getAttribValue("style:column-width");
            if (columnWidth == null) continue;
            style.setWidth(columnWidth);
        }
        return style;
    }

    private RowStyle readRowStyleEntry(XmlReaderInstance reader) {
        RowStyle style = new RowStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-row-properties");
            if (instance == null) {
                return style;
            }
            String rowHeight = instance.getAttribValue("style:row-height");
            if (rowHeight == null) continue;
            style.setHeight(rowHeight);
        }
        return style;
    }

    private void iterateFilesEntries(XmlReaderInstance reader) {
        if (reader == null) {
            return;
        }
        XmlReaderInstance instance = reader.nextElement("office:spreadsheet");
        if (instance != null) {
            this.processSpreadsheet(instance);
        }
    }

    private void processSpreadsheet(XmlReaderInstance reader) {
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("table:table");
            if (instance == null) continue;
            this.processTable(instance);
        }
    }

    private void processTable(XmlReaderInstance reader) {
        String name = reader.getAttribValue("table:name");
        Sheet sheet = new Sheet(name);
        sheet.deleteRow(0);
        sheet.deleteColumn(0);
        int rowCount = 0;
        this.groupCells.clear();
        while (reader.hasNext()) {
            RowStyle rowStyle;
            XmlReaderInstance instance = reader.nextElement("table:table-column", "table:table-row");
            if (instance == null) continue;
            String styleName = instance.getAttribValue("table:default-cell-style-name");
            Style style = null;
            if (styleName != null) {
                style = this.styles.get(styleName);
            }
            if (instance.getTag().equals("table:table-column")) {
                ColumnStyle columnStyle;
                int numColumns = 1;
                String columnsRepeated = instance.getAttribValue("table:number-columns-repeated");
                if (columnsRepeated != null) {
                    numColumns = Integer.parseInt(columnsRepeated);
                }
                if (style != null) {
                    for (int j = sheet.getMaxColumns(); j < sheet.getMaxColumns() + numColumns; ++j) {
                        this.columns_styles.put(j, style);
                    }
                }
                sheet.appendColumns(numColumns);
                String columnStyleName = instance.getAttribValue("table:style-name");
                if (columnStyleName == null || (columnStyle = this.styleColumn.get(columnStyleName)) == null) continue;
                for (int i = 0; i < numColumns; ++i) {
                    sheet.setColumnWidth(sheet.getMaxColumns() - i - 1, columnStyle.getWidth());
                }
                continue;
            }
            if (!instance.getTag().equals("table:table-row")) continue;
            if (style != null) {
                this.rows_styles.put(rowCount, style);
            }
            sheet.appendRow();
            String rowStyleName = instance.getAttribValue("table:style-name");
            if (rowStyleName != null && (rowStyle = this.styleRow.get(rowStyleName)) != null) {
                sheet.setRowHeight(sheet.getMaxRows() - 1, rowStyle.getHeight());
            }
            this.processCells(instance, sheet);
        }
        for (Pair<Vector, Vector> pair : this.groupCells) {
            Vector cord = (Vector)pair.first;
            Vector length = (Vector)pair.second;
            Range range = sheet.getRange(cord.getX(), cord.getY(), length.getX(), length.getY());
            range.merge();
        }
        this.spread.appendSheet(sheet);
    }

    private void processCells(XmlReaderInstance reader, Sheet sheet) {
        int column = 0;
        while (reader.hasNext()) {
            long number_columns_repeated = 0L;
            Object last_cell_value = null;
            Style last_style = null;
            XmlReaderInstance instance = reader.nextElement("table:table-cell", "table:covered-table-cell");
            if (instance != null) {
                Style style;
                String columnsSpanned;
                if (instance.getTag().equals("table:covered-table-cell")) {
                    String numColumnsRepeated = instance.getAttribValue("table:number-columns-repeated");
                    if (numColumnsRepeated == null) {
                        ++column;
                        continue;
                    }
                    column += Integer.parseInt(numColumnsRepeated);
                    continue;
                }
                int rows = 1;
                int columns = 1;
                String rowsSpanned = instance.getAttribValue("table:number-rows-spanned");
                if (rowsSpanned != null) {
                    rows = Integer.parseInt(rowsSpanned);
                }
                if ((columnsSpanned = instance.getAttribValue("table:number-columns-spanned")) != null) {
                    columns = Integer.parseInt(columnsSpanned);
                }
                int positionX = sheet.getMaxRows() - 1;
                int positionY = column;
                if (rows != 1 || columns != 1) {
                    Pair pair = new Pair();
                    pair.first = new Vector(positionX, positionY);
                    pair.second = new Vector(rows, columns);
                    this.groupCells.add(pair);
                }
                Range range = sheet.getRange(positionX, positionY);
                String valueType = instance.getAttribValue("office:value-type");
                if (valueType == null) {
                    valueType = "string";
                }
                String formula = instance.getAttribValue("table:formula");
                range.setFormula(formula);
                Object value = null;
                String raw = instance.getAttribValue("office:value");
                if (raw != null) {
                    value = this.getValue(raw, valueType);
                }
                if ((raw = instance.getAttribValue("table:number-columns-repeated")) != null) {
                    number_columns_repeated = Long.parseLong(raw);
                }
                if ((style = this.styles.get(instance.getAttribValue("table:style-name"))) == null) {
                    style = this.columns_styles.get(column);
                }
                if (style == null) {
                    style = this.rows_styles.get(sheet.getMaxRows() - 1);
                }
                if (style != null) {
                    range.setStyle(style);
                }
                last_style = style;
                if (value == null) {
                    value = this.readCellText(instance);
                }
                last_cell_value = value;
                range.setValue(value);
                ++column;
            }
            if (number_columns_repeated <= 0L) continue;
            int j = 0;
            while ((long)j < number_columns_repeated - 1L) {
                Range range = sheet.getRange(sheet.getMaxRows() - 1, column);
                if (last_style != null) {
                    range.setStyle(last_style);
                }
                range.setValue(last_cell_value);
                ++column;
                ++j;
            }
        }
    }

    private String readCellText(XmlReaderInstance cellReader) {
        StringBuffer s = new StringBuffer();
        XmlReaderInstance textElement = cellReader.nextElement("text:p");
        boolean firstTextElement = true;
        while (textElement != null) {
            if (firstTextElement) {
                firstTextElement = false;
            } else {
                s.append("\n");
            }
            XmlReaderInstance spanElement = textElement.nextElement("text:span");
            while (spanElement != null) {
                String spanContent = spanElement.getContent();
                if (spanContent != null) {
                    s.append(spanContent);
                }
                spanElement = textElement.nextElement("text:span");
            }
            String textContent = textElement.getContent();
            if (textContent != null) {
                s.append(textContent);
            }
            textElement = cellReader.nextElement("text:p");
        }
        if (s.length() <= 0) {
            return null;
        }
        return s.toString();
    }

    private Object getValue(String value, String valueType) {
        try {
            NumberFormat format = NumberFormat.getInstance(defaultLocal);
            switch (valueType) {
                case "integer": {
                    return format.parse(value).longValue();
                }
                case "float": {
                    return format.parse(value).doubleValue();
                }
            }
            return value;
        }
        catch (ParseException e) {
            return value;
        }
    }
}

