/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.TargetHistoryTable;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import java.io.IOException;

public class CCTaskProgressMonitor
implements ProgressMonitor {
    private ProcessorConfiguration config;
    private TargetHistoryTable history;
    private VersionInfo versionInfo;
    private long lastCommit = -1L;

    public CCTaskProgressMonitor(TargetHistoryTable history, VersionInfo versionInfo) {
        this.history = history;
        this.versionInfo = versionInfo;
    }

    public void finish(ProcessorConfiguration config, boolean normal) {
        long current = System.currentTimeMillis();
        if (current - this.lastCommit > 120000L) {
            try {
                this.history.commit();
                this.lastCommit = System.currentTimeMillis();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void progress(String[] sources) {
        this.history.update(this.config, sources, this.versionInfo);
        long current = System.currentTimeMillis();
        if (current - this.lastCommit > 120000L) {
            try {
                this.history.commit();
                this.lastCommit = current;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void start(ProcessorConfiguration config) {
        if (this.lastCommit < 0L) {
            this.lastCommit = System.currentTimeMillis();
        }
        this.config = config;
    }
}

