/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.Position;
import com.github.jferard.fastods.util.PositionBuilder;
import com.github.jferard.fastods.util.PositionParser;
import com.github.jferard.fastods.util.TableNameUtil;
import java.text.ParseException;

public class PositionUtil {
    public static final int ALPHABET_SIZE = 26;
    public static final int ORD_A = 65;
    private final EqualityUtil equalityUtil;
    private final TableNameUtil tableNameUtil;
    private PositionParser parser;

    public static PositionUtil create() {
        return new PositionUtil(new EqualityUtil(), new TableNameUtil());
    }

    public PositionUtil(EqualityUtil equalityUtil, TableNameUtil tableNameUtil) {
        this.equalityUtil = equalityUtil;
        this.tableNameUtil = tableNameUtil;
    }

    public Position newPosition(String address) throws ParseException {
        return new PositionParser(this.equalityUtil, this.tableNameUtil, address).parse();
    }

    public Position newPosition(int row, int col) {
        return new Position(this.equalityUtil, this.tableNameUtil, null, null, row, col, 0);
    }

    public Position newPosition(Table table, int row, int col) {
        return new Position(this.equalityUtil, this.tableNameUtil, null, table.getName(), row, col, 0);
    }

    public String toCellAddress(int row, int col) {
        return this.newPosition(row, col).toString();
    }

    public String toCellAddress(Table table, int row, int col) {
        return this.newPosition(table, row, col).toString();
    }

    public String toRangeAddress(int row1, int col1, int row2, int col2) {
        return this.toCellAddress(row1, col1) + ":" + this.toCellAddress(row2, col2);
    }

    public String toRangeAddress(Table table, int row1, int col1, int row2, int col2) {
        return this.toCellAddress(table, row1, col1) + ":" + this.toCellAddress(table, row2, col2);
    }

    public void checkTableName(String name) {
        this.tableNameUtil.checkTableName(name);
    }

    public PositionBuilder builder(int row, int col) {
        return new PositionBuilder(this.equalityUtil, this.tableNameUtil, row, col);
    }
}

