/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.Length;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class TextPropertiesBuilder {
    private Color fontColor = SimpleColor.NONE;
    private String fontName;
    private Length fontSizeLength;
    private String fontStyle;
    private Color fontUnderlineColor = SimpleColor.NONE;
    private TextProperties.Underline fontUnderlineStyle;
    private String fontWeight;
    private double fontSizePercentage = -1.0;

    TextPropertiesBuilder() {
    }

    public TextProperties build() {
        String fontSize = this.fontSizePercentage > 0.0 ? new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(this.fontSizePercentage) + "%" : (this.fontSizeLength != null ? this.fontSizeLength.toString() : null);
        return new TextProperties(this.fontColor, this.fontName, this.fontWeight, this.fontStyle, fontSize, this.fontUnderlineColor, this.fontUnderlineStyle);
    }

    public TextStyle buildStyle(String name) {
        return new TextStyle(name, false, this.build());
    }

    public TextStyle buildHiddenStyle(String name) {
        if (this.fontSizePercentage > 0.0) {
            throw new IllegalArgumentException("20.183 fo:font-size: fontSizePercentage values can be used within common styles only");
        }
        return new TextStyle(name, true, this.build());
    }

    public TextPropertiesBuilder fontColor(Color color) {
        this.fontColor = color;
        return this;
    }

    public TextPropertiesBuilder fontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public TextPropertiesBuilder fontSize(Length fontSize) {
        this.fontSizePercentage = -1.0;
        this.fontSizeLength = fontSize;
        return this;
    }

    public TextPropertiesBuilder fontSizePercentage(double percentage) {
        this.fontSizeLength = null;
        this.fontSizePercentage = percentage;
        return this;
    }

    public TextPropertiesBuilder fontStyleItalic() {
        this.fontStyle = "italic";
        return this;
    }

    public TextPropertiesBuilder fontStyleNormal() {
        this.fontStyle = "normal";
        return this;
    }

    public TextPropertiesBuilder fontUnderlineColor(Color color) {
        this.fontUnderlineColor = color;
        return this;
    }

    public TextPropertiesBuilder fontUnderlineStyle(TextProperties.Underline style) {
        this.fontUnderlineStyle = style;
        return this;
    }

    public TextPropertiesBuilder fontWeightBold() {
        this.fontWeight = "bold";
        return this;
    }

    public TextPropertiesBuilder fontWeightNormal() {
        this.fontWeight = "normal";
        return this;
    }
}

