/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.style.ShowableBuilder;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableRowStyle;
import com.github.jferard.fastods.style.TableStyleBuilder;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.SimpleLength;
import com.github.jferard.fastods.util.StyleBuilder;

public class TableRowStyleBuilder
implements StyleBuilder<TableRowStyle>,
ShowableBuilder<TableRowStyleBuilder> {
    private static final Length DEFAULT_ROW_HEIGHT = SimpleLength.cm(0.45);
    private final String name;
    private Length rowHeight;
    private boolean hidden;
    private TableCellStyle defaultCellStyle;
    private boolean optimalHeight;

    TableRowStyleBuilder(String name) {
        this.name = TableStyleBuilder.checker.checkStyleName(name);
        this.rowHeight = DEFAULT_ROW_HEIGHT;
        this.hidden = true;
        this.defaultCellStyle = null;
        this.optimalHeight = false;
    }

    @Override
    public TableRowStyle build() {
        return new TableRowStyle(this.name, this.hidden, this.rowHeight, this.defaultCellStyle, this.optimalHeight);
    }

    public TableRowStyleBuilder defaultCellStyle(TableCellStyle defaultCellStyle) {
        this.defaultCellStyle = defaultCellStyle;
        return this;
    }

    @Override
    public TableRowStyleBuilder visible() {
        this.hidden = false;
        return this;
    }

    public TableRowStyleBuilder rowHeight(Length height) {
        this.rowHeight = height;
        this.optimalHeight = false;
        return this;
    }

    @Deprecated
    public TableRowStyleBuilder optimalHeight() {
        this.optimalHeight = true;
        this.rowHeight = Length.NULL_LENGTH;
        return this;
    }
}

