/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.Footer;
import com.github.jferard.fastods.Header;
import com.github.jferard.fastods.PageSection;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.style.HidableBuilder;
import com.github.jferard.fastods.style.MarginsBuilder;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.PaperFormat;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.SimpleLength;
import com.github.jferard.fastods.util.StyleBuilder;

public class PageStyleBuilder
implements StyleBuilder<PageStyle>,
HidableBuilder<PageStyleBuilder> {
    private static final Length DEFAULT_MARGIN_SIZE = SimpleLength.cm(1.5);
    private final MarginsBuilder marginsBuilder;
    private final String name;
    private final String numFormat;
    private Color backgroundColor;
    private Footer footer;
    private Header header;
    private Length pageHeight;
    private Length pageWidth;
    private PaperFormat paperFormat;
    private PageStyle.PrintOrientation printOrientation;
    private PageStyle.WritingMode writingMode;
    private MasterPageStyle masterPageStyle;
    private PageLayoutStyle pageLayoutStyle;
    private boolean hidden;
    private int scaleTo;
    private int scaleToPages;
    private PageStyle.Centering centering;

    PageStyleBuilder(String name) {
        if (name == null) {
            throw new IllegalStateException();
        }
        this.name = name;
        this.marginsBuilder = new MarginsBuilder();
        this.marginsBuilder.all(DEFAULT_MARGIN_SIZE);
        this.paperFormat = PageStyle.DEFAULT_FORMAT;
        this.pageWidth = PageStyle.DEFAULT_FORMAT.getWidth();
        this.pageHeight = PageStyle.DEFAULT_FORMAT.getHeight();
        this.numFormat = "1";
        this.backgroundColor = SimpleColor.NONE;
        this.printOrientation = PageStyle.DEFAULT_PRINT_ORIENTATION;
        this.writingMode = PageStyle.DEFAULT_WRITING_MODE;
        this.scaleTo = 100;
        this.scaleToPages = 0;
        this.centering = PageStyle.Centering.NONE;
        TextStyle noneStyle = TextProperties.builder().buildHiddenStyle("none");
        this.header = PageSection.simpleHeader("", noneStyle);
        this.footer = PageSection.simpleFooter("", noneStyle);
        this.hidden = false;
    }

    public PageStyleBuilder allMargins(Length margin) {
        this.marginsBuilder.all(margin);
        return this;
    }

    public PageStyleBuilder backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    @Override
    public PageStyle build() {
        if (this.masterPageStyle == null) {
            this.masterPageStyle = new MasterPageStyle(this.name, this.name, this.header, this.footer);
        }
        if (this.pageLayoutStyle == null) {
            this.pageLayoutStyle = new PageLayoutStyle(this.name, this.marginsBuilder.build(), this.pageWidth, this.pageHeight, this.numFormat, this.backgroundColor, this.header, this.footer, this.printOrientation, this.writingMode, this.scaleTo, this.scaleToPages, this.centering);
        }
        return new PageStyle(this.hidden, this.masterPageStyle, this.pageLayoutStyle);
    }

    public PageStyleBuilder masterPageStyle(MasterPageStyle masterPageStyle) {
        this.masterPageStyle = masterPageStyle;
        return this;
    }

    public PageStyleBuilder pageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        this.pageLayoutStyle = pageLayoutStyle;
        return this;
    }

    public PageStyleBuilder footer(Footer footer) {
        this.footer = footer;
        return this;
    }

    public PageStyleBuilder header(Header header) {
        this.header = header;
        return this;
    }

    public PageStyleBuilder marginBottom(Length margin) {
        this.marginsBuilder.bottom(margin);
        return this;
    }

    public PageStyleBuilder marginLeft(Length margin) {
        this.marginsBuilder.left(margin);
        return this;
    }

    public PageStyleBuilder marginRight(Length margin) {
        this.marginsBuilder.right(margin);
        return this;
    }

    public PageStyleBuilder marginTop(Length margin) {
        this.marginsBuilder.top(margin);
        return this;
    }

    public PageStyleBuilder pageHeight(Length pageHeight) {
        this.paperFormat = PaperFormat.USER;
        this.pageHeight = pageHeight;
        return this;
    }

    public PageStyleBuilder pageWidth(Length pageWidth) {
        this.paperFormat = PaperFormat.USER;
        this.pageWidth = pageWidth;
        return this;
    }

    public final PageStyleBuilder paperFormat(PaperFormat paperFormat) {
        this.paperFormat = paperFormat;
        this.pageWidth = paperFormat.getWidth();
        this.pageHeight = paperFormat.getHeight();
        return this;
    }

    public PageStyleBuilder printOrientationHorizontal() {
        if (this.paperFormat == PaperFormat.USER) {
            Length w = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = w;
        } else {
            this.pageWidth = this.paperFormat.getHeight();
            this.pageHeight = this.paperFormat.getWidth();
        }
        this.printOrientation = PageStyle.PrintOrientation.HORIZONTAL;
        return this;
    }

    public PageStyleBuilder printOrientationVertical() {
        this.pageWidth = this.paperFormat.getWidth();
        this.pageHeight = this.paperFormat.getHeight();
        this.printOrientation = PageStyle.PrintOrientation.VERTICAL;
        return this;
    }

    public PageStyleBuilder writingMode(PageStyle.WritingMode writingMode) {
        if (writingMode == null) {
            throw new IllegalArgumentException();
        }
        this.writingMode = writingMode;
        return this;
    }

    @Override
    public PageStyleBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public PageStyleBuilder scaleTo(int percentage) {
        this.scaleTo = percentage;
        return this;
    }

    public PageStyleBuilder scaleToPages(int pages) {
        this.scaleToPages = pages;
        return this;
    }

    public PageStyleBuilder centering(PageStyle.Centering centering) {
        this.centering = centering;
        return this;
    }
}

