/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.style.BorderAttribute;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.SimpleLength;

public class BorderAttributeBuilder {
    private Color borderColor;
    private Length borderSize;
    private BorderAttribute.Style style = BorderAttribute.DEFAULT_STYLE;

    BorderAttributeBuilder() {
        this.borderColor = SimpleColor.NONE;
    }

    public BorderAttributeBuilder borderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public BorderAttributeBuilder borderSize(int size) {
        this.borderSize = SimpleLength.pt(size);
        return this;
    }

    public BorderAttributeBuilder borderSize(Length borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    public BorderAttributeBuilder borderStyle(BorderAttribute.Style style) {
        this.style = style;
        return this;
    }

    public BorderAttribute build() {
        return new BorderAttribute(this.borderSize, this.borderColor, this.style);
    }
}

