/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.CoreDataStyle;
import com.github.jferard.fastods.datastyle.IsVolatileBuilder;
import com.github.jferard.fastods.datastyle.LocalizedBuilder;
import com.github.jferard.fastods.style.ShowableBuilder;
import com.github.jferard.fastods.util.NameChecker;
import com.github.jferard.fastods.util.StyleBuilder;
import java.util.Locale;

final class CoreDataStyleBuilder
implements StyleBuilder<CoreDataStyle>,
LocalizedBuilder<CoreDataStyleBuilder>,
IsVolatileBuilder<CoreDataStyleBuilder>,
ShowableBuilder<CoreDataStyleBuilder> {
    private static final NameChecker checker = new NameChecker();
    private final String name;
    private String countryCode;
    private String languageCode;
    private boolean volatileStyle;
    private boolean hidden;

    CoreDataStyleBuilder(String name, Locale locale) {
        this.name = checker.checkStyleName(name);
        this.countryCode = locale.getCountry();
        this.languageCode = locale.getLanguage();
        this.volatileStyle = true;
        this.hidden = true;
    }

    @Override
    public CoreDataStyle build() {
        return new CoreDataStyle(this.name, this.hidden, this.languageCode, this.countryCode, this.volatileStyle);
    }

    @Override
    public CoreDataStyleBuilder country(String countryCode) {
        this.countryCode = countryCode.toUpperCase();
        return this;
    }

    @Override
    public CoreDataStyleBuilder language(String languageCode) {
        this.languageCode = languageCode.toLowerCase();
        return this;
    }

    @Override
    public CoreDataStyleBuilder locale(Locale locale) {
        this.countryCode = locale.getCountry();
        this.languageCode = locale.getLanguage();
        return this;
    }

    @Override
    public CoreDataStyleBuilder volatileStyle(boolean volatileStyle) {
        this.volatileStyle = volatileStyle;
        return this;
    }

    @Override
    public CoreDataStyleBuilder visible() {
        this.hidden = false;
        return this;
    }
}

