/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Paragraph;
import com.github.jferard.fastods.ParagraphBuilder;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.style.TextStyle;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class TextBuilder {
    private final List<Paragraph> paragraphs;
    private ParagraphBuilder curParagraphBuilder;

    public static TextBuilder create() {
        return new TextBuilder(new ArrayList<Paragraph>());
    }

    TextBuilder(List<Paragraph> paragraphs) {
        this.paragraphs = paragraphs;
        this.curParagraphBuilder = null;
    }

    public Text build() {
        this.flushCurPar();
        return new Text(this.paragraphs);
    }

    public TextBuilder par() {
        this.flushCurPar();
        this.curParagraphBuilder = new ParagraphBuilder();
        return this;
    }

    private void flushCurPar() {
        if (this.curParagraphBuilder != null) {
            this.paragraphs.add(this.curParagraphBuilder.build());
        }
    }

    public TextBuilder parContent(String text) {
        return this.par().span(text);
    }

    public TextBuilder parStyledContent(String text, TextStyle ts) {
        return this.par().styledSpan(text, ts);
    }

    public TextBuilder span(String text) {
        this.curParagraphBuilder.span(text);
        return this;
    }

    public TextBuilder link(String text, Table table) {
        this.curParagraphBuilder.link(text, table);
        return this;
    }

    public TextBuilder styledLink(String text, TextStyle ts, Table table) {
        this.curParagraphBuilder.styledLink(text, ts, table);
        return this;
    }

    public TextBuilder link(String text, File file) {
        this.curParagraphBuilder.link(text, file);
        return this;
    }

    public TextBuilder styledLink(String text, TextStyle ts, File file) {
        this.curParagraphBuilder.styledLink(text, ts, file);
        return this;
    }

    public TextBuilder link(String text, URL url) {
        this.curParagraphBuilder.link(text, url);
        return this;
    }

    public TextBuilder styledLink(String text, TextStyle ts, URL url) {
        this.curParagraphBuilder.styledLink(text, ts, url);
        return this;
    }

    public TextBuilder link(String text, URI uri) {
        this.curParagraphBuilder.link(text, uri);
        return this;
    }

    public TextBuilder styledLink(String text, TextStyle ts, URI uri) {
        this.curParagraphBuilder.styledLink(text, ts, uri);
        return this;
    }

    public TextBuilder link(String text, String ref) {
        this.curParagraphBuilder.link(text, ref);
        return this;
    }

    public TextBuilder styledLink(String text, TextStyle ts, String ref) {
        this.curParagraphBuilder.styledLink(text, ts, ref);
        return this;
    }

    public TextBuilder styledSpan(String text, TextStyle ts) {
        this.curParagraphBuilder.styledSpan(text, ts);
        return this;
    }
}

