/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.ParagraphElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class Span
implements ParagraphElement {
    private final String text;
    private final TextStyle ts;

    public Span(String text) {
        this(text, null);
    }

    public Span(String text, TextStyle ts) {
        this.ts = ts;
        this.text = text;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        if (this.ts == null) {
            appendable.append(this.text);
        } else {
            appendable.append("<text:span");
            util.appendEAttribute(appendable, "text:style-name", this.ts.getName());
            appendable.append(">").append(this.text).append("</text:span>");
        }
    }

    @Override
    public void addEmbeddedStylesFromFooterHeader(StylesContainer stylesContainer) {
        if (this.ts != null) {
            stylesContainer.addStylesFontFaceContainerStyle(this.ts);
        }
    }

    @Override
    public void addEmbeddedStylesFromCell(StylesContainer stylesContainer) {
        if (this.ts != null) {
            stylesContainer.addContentFontFaceContainerStyle(this.ts);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Span)) {
            return false;
        }
        Span other = (Span)o;
        return this.text.equals(other.text);
    }

    public final int hashCode() {
        return this.text.hashCode();
    }
}

