/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.PageSectionContent;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

class RegionFooterHeader
implements PageSectionContent {
    private final Text centerRegion;
    private final Text leftRegion;
    private final Text rightRegion;

    private static void appendRegionXMLToMasterStyle(XMLUtil util, Appendable appendable, Text region, CharSequence regionName) throws IOException {
        if (region == null || region.isEmpty()) {
            return;
        }
        appendable.append("<style:").append(regionName).append(">");
        region.appendXMLContent(util, appendable);
        appendable.append("</style:").append(regionName).append(">");
    }

    RegionFooterHeader(Text centerRegion, Text leftRegion, Text rightRegion) {
        this.centerRegion = centerRegion;
        this.leftRegion = leftRegion;
        this.rightRegion = rightRegion;
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        if (this.leftRegion != null && !this.leftRegion.isEmpty()) {
            this.leftRegion.addEmbeddedStylesFromFooterHeader(stylesContainer);
        }
        if (this.centerRegion != null && !this.centerRegion.isEmpty()) {
            this.centerRegion.addEmbeddedStylesFromFooterHeader(stylesContainer);
        }
        if (this.rightRegion != null && !this.rightRegion.isEmpty()) {
            this.rightRegion.addEmbeddedStylesFromFooterHeader(stylesContainer);
        }
    }

    @Override
    public void appendXMLToMasterStyle(XMLUtil util, Appendable appendable) throws IOException {
        RegionFooterHeader.appendRegionXMLToMasterStyle(util, appendable, this.leftRegion, "region-left");
        RegionFooterHeader.appendRegionXMLToMasterStyle(util, appendable, this.centerRegion, "region-center");
        RegionFooterHeader.appendRegionXMLToMasterStyle(util, appendable, this.rightRegion, "region-right");
    }
}

