/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.OdsFlusher;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class PreprocessedRowsFlusher
implements OdsFlusher {
    private static final int STRING_BUILDER_SIZE = 32768;
    private final StringBuilder sb;

    public static PreprocessedRowsFlusher create(XMLUtil xmlUtil, List<TableRowImpl> tableRows) throws IOException {
        return new PreprocessedRowsFlusher(xmlUtil, tableRows, new StringBuilder(32768));
    }

    PreprocessedRowsFlusher(XMLUtil xmlUtil, List<TableRowImpl> rows, StringBuilder sb) throws IOException {
        this.sb = sb;
        for (TableRowImpl row : rows) {
            TableRowImpl.appendXMLToTable(row, xmlUtil, this.sb);
        }
        Collections.fill(rows, null);
    }

    @Override
    public void flushInto(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        writer.append(this.sb);
    }

    @Override
    public boolean isEnd() {
        return false;
    }
}

