/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Footer;
import com.github.jferard.fastods.Header;
import com.github.jferard.fastods.PageSection;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.style.MarginsBuilder;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.Box;
import com.github.jferard.fastods.util.Length;

public abstract class PageSectionBuilder<F extends PageSectionBuilder<F>> {
    protected Box<Text> curRegionBox;
    protected final MarginsBuilder marginsBuilder;
    protected Length minHeight = Length.NULL_LENGTH;

    PageSectionBuilder() {
        this.marginsBuilder = new MarginsBuilder();
        this.marginsBuilder.all(Length.NULL_LENGTH);
    }

    public F allMargins(Length margin) {
        this.marginsBuilder.all(margin);
        return (F)this;
    }

    protected abstract PageSection build();

    public F content(String string) {
        this.curRegionBox.set(Text.content(string));
        return (F)this;
    }

    public F marginBottom(Length margin) {
        this.marginsBuilder.bottom(margin);
        return (F)this;
    }

    public F marginLeft(Length margin) {
        this.marginsBuilder.left(margin);
        return (F)this;
    }

    public F marginRight(Length margin) {
        this.marginsBuilder.right(margin);
        return (F)this;
    }

    public F marginTop(Length margin) {
        this.marginsBuilder.top(margin);
        return (F)this;
    }

    public F minHeight(Length height) {
        this.minHeight = height;
        return (F)this;
    }

    public F styledContent(String text, TextStyle ts) {
        this.curRegionBox.set(Text.styledContent(text, ts));
        return (F)this;
    }

    public F text(Text text) {
        this.curRegionBox.set(text);
        return (F)this;
    }

    public Header buildHeader() {
        return new Header(this.build());
    }

    public Footer buildFooter() {
        return new Footer(this.build());
    }
}

