/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsFlusher;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;

public class OdsFileWriterAdapter
implements NamedOdsFileWriter {
    private final NamedOdsFileWriter adaptee;
    private final Queue<OdsFlusher> flushers;
    private boolean stopped;

    public static OdsFileWriterAdapter create(NamedOdsFileWriter adaptee) {
        return new OdsFileWriterAdapter(adaptee, new LinkedList<OdsFlusher>());
    }

    OdsFileWriterAdapter(NamedOdsFileWriter adaptee, Queue<OdsFlusher> flushers) {
        this.adaptee = adaptee;
        this.flushers = flushers;
    }

    @Override
    public void close() {
    }

    @Override
    public NamedOdsDocument document() {
        return this.adaptee.document();
    }

    @Override
    public synchronized void save() {
    }

    @Override
    public synchronized void update(OdsFlusher flusher) {
        this.flushers.add(flusher);
        this.notifyAll();
    }

    public synchronized void flushAdaptee() throws IOException {
        OdsFlusher flusher = this.flushers.poll();
        if (flusher == null) {
            return;
        }
        while (flusher != null) {
            this.adaptee.update(flusher);
            if (flusher.isEnd()) {
                this.stopped = true;
                this.notifyAll();
                return;
            }
            flusher = this.flushers.poll();
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        this.notifyAll();
    }

    public synchronized boolean isNotStopped() {
        return !this.stopped;
    }

    public synchronized void waitForData() {
        while (this.flushers.isEmpty() && this.isNotStopped()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

